package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcChannelMetrics invokes the rtc.DescribeRtcChannelMetrics API synchronously
func (client *Client) DescribeRtcChannelMetrics(request *DescribeRtcChannelMetricsRequest) (response *DescribeRtcChannelMetricsResponse, err error) {
	response = CreateDescribeRtcChannelMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcChannelMetricsWithChan invokes the rtc.DescribeRtcChannelMetrics API asynchronously
func (client *Client) DescribeRtcChannelMetricsWithChan(request *DescribeRtcChannelMetricsRequest) (<-chan *DescribeRtcChannelMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcChannelMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcChannelMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcChannelMetricsWithCallback invokes the rtc.DescribeRtcChannelMetrics API asynchronously
func (client *Client) DescribeRtcChannelMetricsWithCallback(request *DescribeRtcChannelMetricsRequest, callback func(response *DescribeRtcChannelMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcChannelMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcChannelMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcChannelMetricsRequest is the request struct for api DescribeRtcChannelMetrics
type DescribeRtcChannelMetricsRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	SubUid    string           `position:"Query" name:"SubUid"`
	PubUid    string           `position:"Query" name:"PubUid"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeRtcChannelMetricsResponse is the response struct for api DescribeRtcChannelMetrics
type DescribeRtcChannelMetricsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Metrics   []Metric `json:"Metrics" xml:"Metrics"`
}

// CreateDescribeRtcChannelMetricsRequest creates a request to invoke DescribeRtcChannelMetrics API
func CreateDescribeRtcChannelMetricsRequest() (request *DescribeRtcChannelMetricsRequest) {
	request = &DescribeRtcChannelMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcChannelMetrics", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcChannelMetricsResponse creates a response to parse from DescribeRtcChannelMetrics response
func CreateDescribeRtcChannelMetricsResponse() (response *DescribeRtcChannelMetricsResponse) {
	response = &DescribeRtcChannelMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
