package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcChannelUserList invokes the rtc.DescribeRtcChannelUserList API synchronously
func (client *Client) DescribeRtcChannelUserList(request *DescribeRtcChannelUserListRequest) (response *DescribeRtcChannelUserListResponse, err error) {
	response = CreateDescribeRtcChannelUserListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcChannelUserListWithChan invokes the rtc.DescribeRtcChannelUserList API asynchronously
func (client *Client) DescribeRtcChannelUserListWithChan(request *DescribeRtcChannelUserListRequest) (<-chan *DescribeRtcChannelUserListResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcChannelUserListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcChannelUserList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcChannelUserListWithCallback invokes the rtc.DescribeRtcChannelUserList API asynchronously
func (client *Client) DescribeRtcChannelUserListWithCallback(request *DescribeRtcChannelUserListRequest, callback func(response *DescribeRtcChannelUserListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcChannelUserListResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcChannelUserList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcChannelUserListRequest is the request struct for api DescribeRtcChannelUserList
type DescribeRtcChannelUserListRequest struct {
	*requests.RpcRequest
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	PageNo    requests.Integer `position:"Query" name:"PageNo"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
	TimePoint string           `position:"Query" name:"TimePoint"`
}

// DescribeRtcChannelUserListResponse is the response struct for api DescribeRtcChannelUserList
type DescribeRtcChannelUserListResponse struct {
	*responses.BaseResponse
	RequestId string                               `json:"RequestId" xml:"RequestId"`
	PageSize  int64                                `json:"PageSize" xml:"PageSize"`
	PageNo    int64                                `json:"PageNo" xml:"PageNo"`
	TotalCnt  int64                                `json:"TotalCnt" xml:"TotalCnt"`
	UserList  UserListInDescribeRtcChannelUserList `json:"UserList" xml:"UserList"`
}

// CreateDescribeRtcChannelUserListRequest creates a request to invoke DescribeRtcChannelUserList API
func CreateDescribeRtcChannelUserListRequest() (request *DescribeRtcChannelUserListRequest) {
	request = &DescribeRtcChannelUserListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcChannelUserList", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcChannelUserListResponse creates a response to parse from DescribeRtcChannelUserList response
func CreateDescribeRtcChannelUserListResponse() (response *DescribeRtcChannelUserListResponse) {
	response = &DescribeRtcChannelUserListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
