package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateConfigMap invokes the sae.UpdateConfigMap API synchronously
func (client *Client) UpdateConfigMap(request *UpdateConfigMapRequest) (response *UpdateConfigMapResponse, err error) {
	response = CreateUpdateConfigMapResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateConfigMapWithChan invokes the sae.UpdateConfigMap API asynchronously
func (client *Client) UpdateConfigMapWithChan(request *UpdateConfigMapRequest) (<-chan *UpdateConfigMapResponse, <-chan error) {
	responseChan := make(chan *UpdateConfigMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateConfigMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateConfigMapWithCallback invokes the sae.UpdateConfigMap API asynchronously
func (client *Client) UpdateConfigMapWithCallback(request *UpdateConfigMapRequest, callback func(response *UpdateConfigMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateConfigMapResponse
		var err error
		defer close(result)
		response, err = client.UpdateConfigMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateConfigMapRequest is the request struct for api UpdateConfigMap
type UpdateConfigMapRequest struct {
	*requests.RoaRequest
	Data        string           `position:"Body" name:"Data"`
	Description string           `position:"Body" name:"Description"`
	ConfigMapId requests.Integer `position:"Query" name:"ConfigMapId"`
}

// UpdateConfigMapResponse is the response struct for api UpdateConfigMap
type UpdateConfigMapResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Code      string                `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	ErrorCode string                `json:"ErrorCode" xml:"ErrorCode"`
	TraceId   string                `json:"TraceId" xml:"TraceId"`
	Success   bool                  `json:"Success" xml:"Success"`
	Data      DataInUpdateConfigMap `json:"Data" xml:"Data"`
}

// CreateUpdateConfigMapRequest creates a request to invoke UpdateConfigMap API
func CreateUpdateConfigMapRequest() (request *UpdateConfigMapRequest) {
	request = &UpdateConfigMapRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "UpdateConfigMap", "/pop/v1/sam/configmap/configMap", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateConfigMapResponse creates a response to parse from UpdateConfigMap response
func CreateUpdateConfigMapResponse() (response *UpdateConfigMapResponse) {
	response = &UpdateConfigMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
