package saf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteRequestSG invokes the saf.ExecuteRequestSG API synchronously
// api document: https://help.aliyun.com/api/saf/executerequestsg.html
func (client *Client) ExecuteRequestSG(request *ExecuteRequestSGRequest) (response *ExecuteRequestSGResponse, err error) {
	response = CreateExecuteRequestSGResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteRequestSGWithChan invokes the saf.ExecuteRequestSG API asynchronously
// api document: https://help.aliyun.com/api/saf/executerequestsg.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecuteRequestSGWithChan(request *ExecuteRequestSGRequest) (<-chan *ExecuteRequestSGResponse, <-chan error) {
	responseChan := make(chan *ExecuteRequestSGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteRequestSG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteRequestSGWithCallback invokes the saf.ExecuteRequestSG API asynchronously
// api document: https://help.aliyun.com/api/saf/executerequestsg.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecuteRequestSGWithCallback(request *ExecuteRequestSGRequest, callback func(response *ExecuteRequestSGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteRequestSGResponse
		var err error
		defer close(result)
		response, err = client.ExecuteRequestSG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteRequestSGRequest is the request struct for api ExecuteRequestSG
type ExecuteRequestSGRequest struct {
	*requests.RpcRequest
	ServiceParameters string `position:"Query" name:"ServiceParameters"`
	Service           string `position:"Query" name:"Service"`
}

// ExecuteRequestSGResponse is the response struct for api ExecuteRequestSG
type ExecuteRequestSGResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Code      int                    `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateExecuteRequestSGRequest creates a request to invoke ExecuteRequestSG API
func CreateExecuteRequestSGRequest() (request *ExecuteRequestSGRequest) {
	request = &ExecuteRequestSGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("saf", "2019-05-21", "ExecuteRequestSG", "saf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExecuteRequestSGResponse creates a response to parse from ExecuteRequestSG response
func CreateExecuteRequestSGResponse() (response *ExecuteRequestSGResponse) {
	response = &ExecuteRequestSGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
