package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAlertHistories invokes the sls.GetAlertHistories API synchronously
func (client *Client) GetAlertHistories(request *GetAlertHistoriesRequest) (response *GetAlertHistoriesResponse, err error) {
	response = CreateGetAlertHistoriesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAlertHistoriesWithChan invokes the sls.GetAlertHistories API asynchronously
func (client *Client) GetAlertHistoriesWithChan(request *GetAlertHistoriesRequest) (<-chan *GetAlertHistoriesResponse, <-chan error) {
	responseChan := make(chan *GetAlertHistoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAlertHistories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAlertHistoriesWithCallback invokes the sls.GetAlertHistories API asynchronously
func (client *Client) GetAlertHistoriesWithCallback(request *GetAlertHistoriesRequest, callback func(response *GetAlertHistoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAlertHistoriesResponse
		var err error
		defer close(result)
		response, err = client.GetAlertHistories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAlertHistoriesRequest is the request struct for api GetAlertHistories
type GetAlertHistoriesRequest struct {
	*requests.RpcRequest
	Line        requests.Integer `position:"Body" name:"Line"`
	ToTs        requests.Integer `position:"Body" name:"ToTs"`
	Endpoint    string           `position:"Body" name:"Endpoint"`
	App         string           `position:"Body" name:"App"`
	FromTs      requests.Integer `position:"Body" name:"FromTs"`
	ProjectName string           `position:"Body" name:"ProjectName"`
	Offset      requests.Integer `position:"Body" name:"Offset"`
	AlertId     string           `position:"Body" name:"AlertId"`
	Region      string           `position:"Body" name:"Region"`
}

// GetAlertHistoriesResponse is the response struct for api GetAlertHistories
type GetAlertHistoriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetAlertHistoriesRequest creates a request to invoke GetAlertHistories API
func CreateGetAlertHistoriesRequest() (request *GetAlertHistoriesRequest) {
	request = &GetAlertHistoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "GetAlertHistories", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAlertHistoriesResponse creates a response to parse from GetAlertHistories response
func CreateGetAlertHistoriesResponse() (response *GetAlertHistoriesResponse) {
	response = &GetAlertHistoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
