package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectTaskFlow invokes the teambition_aliyun.ListProjectTaskFlow API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/listprojecttaskflow.html
func (client *Client) ListProjectTaskFlow(request *ListProjectTaskFlowRequest) (response *ListProjectTaskFlowResponse, err error) {
	response = CreateListProjectTaskFlowResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectTaskFlowWithChan invokes the teambition_aliyun.ListProjectTaskFlow API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/listprojecttaskflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListProjectTaskFlowWithChan(request *ListProjectTaskFlowRequest) (<-chan *ListProjectTaskFlowResponse, <-chan error) {
	responseChan := make(chan *ListProjectTaskFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectTaskFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectTaskFlowWithCallback invokes the teambition_aliyun.ListProjectTaskFlow API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/listprojecttaskflow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListProjectTaskFlowWithCallback(request *ListProjectTaskFlowRequest, callback func(response *ListProjectTaskFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectTaskFlowResponse
		var err error
		defer close(result)
		response, err = client.ListProjectTaskFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectTaskFlowRequest is the request struct for api ListProjectTaskFlow
type ListProjectTaskFlowRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// ListProjectTaskFlowResponse is the response struct for api ListProjectTaskFlow
type ListProjectTaskFlowResponse struct {
	*responses.BaseResponse
	Successful bool       `json:"Successful" xml:"Successful"`
	ErrorCode  string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string     `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Object     []Taskflow `json:"Object" xml:"Object"`
}

// CreateListProjectTaskFlowRequest creates a request to invoke ListProjectTaskFlow API
func CreateListProjectTaskFlowRequest() (request *ListProjectTaskFlowRequest) {
	request = &ListProjectTaskFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "ListProjectTaskFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateListProjectTaskFlowResponse creates a response to parse from ListProjectTaskFlow response
func CreateListProjectTaskFlowResponse() (response *ListProjectTaskFlowResponse) {
	response = &ListProjectTaskFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
