package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVbrHa invokes the vpc.CreateVbrHa API synchronously
func (client *Client) CreateVbrHa(request *CreateVbrHaRequest) (response *CreateVbrHaResponse, err error) {
	response = CreateCreateVbrHaResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVbrHaWithChan invokes the vpc.CreateVbrHa API asynchronously
func (client *Client) CreateVbrHaWithChan(request *CreateVbrHaRequest) (<-chan *CreateVbrHaResponse, <-chan error) {
	responseChan := make(chan *CreateVbrHaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVbrHa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVbrHaWithCallback invokes the vpc.CreateVbrHa API asynchronously
func (client *Client) CreateVbrHaWithCallback(request *CreateVbrHaRequest, callback func(response *CreateVbrHaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVbrHaResponse
		var err error
		defer close(result)
		response, err = client.CreateVbrHa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVbrHaRequest is the request struct for api CreateVbrHa
type CreateVbrHaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	VbrId                string           `position:"Query" name:"VbrId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PeerVbrId            string           `position:"Query" name:"PeerVbrId"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateVbrHaResponse is the response struct for api CreateVbrHa
type CreateVbrHaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	VbrHaId   string `json:"VbrHaId" xml:"VbrHaId"`
}

// CreateCreateVbrHaRequest creates a request to invoke CreateVbrHa API
func CreateCreateVbrHaRequest() (request *CreateVbrHaRequest) {
	request = &CreateVbrHaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateVbrHa", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVbrHaResponse creates a response to parse from CreateVbrHa response
func CreateCreateVbrHaResponse() (response *CreateVbrHaResponse) {
	response = &CreateVbrHaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
