package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteDevices invokes the vs.BatchDeleteDevices API synchronously
func (client *Client) BatchDeleteDevices(request *BatchDeleteDevicesRequest) (response *BatchDeleteDevicesResponse, err error) {
	response = CreateBatchDeleteDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteDevicesWithChan invokes the vs.BatchDeleteDevices API asynchronously
func (client *Client) BatchDeleteDevicesWithChan(request *BatchDeleteDevicesRequest) (<-chan *BatchDeleteDevicesResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteDevicesWithCallback invokes the vs.BatchDeleteDevices API asynchronously
func (client *Client) BatchDeleteDevicesWithCallback(request *BatchDeleteDevicesRequest, callback func(response *BatchDeleteDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteDevicesResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteDevicesRequest is the request struct for api BatchDeleteDevices
type BatchDeleteDevicesRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// BatchDeleteDevicesResponse is the response struct for api BatchDeleteDevices
type BatchDeleteDevicesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchDeleteDevicesRequest creates a request to invoke BatchDeleteDevices API
func CreateBatchDeleteDevicesRequest() (request *BatchDeleteDevicesRequest) {
	request = &BatchDeleteDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchDeleteDevices", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchDeleteDevicesResponse creates a response to parse from BatchDeleteDevices response
func CreateBatchDeleteDevicesResponse() (response *BatchDeleteDevicesResponse) {
	response = &BatchDeleteDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
