package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainCertificateInfo invokes the vs.DescribeVsDomainCertificateInfo API synchronously
func (client *Client) DescribeVsDomainCertificateInfo(request *DescribeVsDomainCertificateInfoRequest) (response *DescribeVsDomainCertificateInfoResponse, err error) {
	response = CreateDescribeVsDomainCertificateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainCertificateInfoWithChan invokes the vs.DescribeVsDomainCertificateInfo API asynchronously
func (client *Client) DescribeVsDomainCertificateInfoWithChan(request *DescribeVsDomainCertificateInfoRequest) (<-chan *DescribeVsDomainCertificateInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainCertificateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainCertificateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainCertificateInfoWithCallback invokes the vs.DescribeVsDomainCertificateInfo API asynchronously
func (client *Client) DescribeVsDomainCertificateInfoWithCallback(request *DescribeVsDomainCertificateInfoRequest, callback func(response *DescribeVsDomainCertificateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainCertificateInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainCertificateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainCertificateInfoRequest is the request struct for api DescribeVsDomainCertificateInfo
type DescribeVsDomainCertificateInfoRequest struct {
	*requests.RpcRequest
	ShowLog    string           `position:"Query" name:"ShowLog"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsDomainCertificateInfoResponse is the response struct for api DescribeVsDomainCertificateInfo
type DescribeVsDomainCertificateInfoResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	CertInfos CertInfos `json:"CertInfos" xml:"CertInfos"`
}

// CreateDescribeVsDomainCertificateInfoRequest creates a request to invoke DescribeVsDomainCertificateInfo API
func CreateDescribeVsDomainCertificateInfoRequest() (request *DescribeVsDomainCertificateInfoRequest) {
	request = &DescribeVsDomainCertificateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainCertificateInfo", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainCertificateInfoResponse creates a response to parse from DescribeVsDomainCertificateInfo response
func CreateDescribeVsDomainCertificateInfoResponse() (response *DescribeVsDomainCertificateInfoResponse) {
	response = &DescribeVsDomainCertificateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
