package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainTrafficData invokes the vs.DescribeVsDomainTrafficData API synchronously
func (client *Client) DescribeVsDomainTrafficData(request *DescribeVsDomainTrafficDataRequest) (response *DescribeVsDomainTrafficDataResponse, err error) {
	response = CreateDescribeVsDomainTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainTrafficDataWithChan invokes the vs.DescribeVsDomainTrafficData API asynchronously
func (client *Client) DescribeVsDomainTrafficDataWithChan(request *DescribeVsDomainTrafficDataRequest) (<-chan *DescribeVsDomainTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainTrafficDataWithCallback invokes the vs.DescribeVsDomainTrafficData API asynchronously
func (client *Client) DescribeVsDomainTrafficDataWithCallback(request *DescribeVsDomainTrafficDataRequest, callback func(response *DescribeVsDomainTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainTrafficDataRequest is the request struct for api DescribeVsDomainTrafficData
type DescribeVsDomainTrafficDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeVsDomainTrafficDataResponse is the response struct for api DescribeVsDomainTrafficData
type DescribeVsDomainTrafficDataResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	DomainName             string                 `json:"DomainName" xml:"DomainName"`
	StartTime              string                 `json:"StartTime" xml:"StartTime"`
	EndTime                string                 `json:"EndTime" xml:"EndTime"`
	DataInterval           string                 `json:"DataInterval" xml:"DataInterval"`
	TrafficDataPerInterval TrafficDataPerInterval `json:"TrafficDataPerInterval" xml:"TrafficDataPerInterval"`
}

// CreateDescribeVsDomainTrafficDataRequest creates a request to invoke DescribeVsDomainTrafficData API
func CreateDescribeVsDomainTrafficDataRequest() (request *DescribeVsDomainTrafficDataRequest) {
	request = &DescribeVsDomainTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainTrafficData", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainTrafficDataResponse creates a response to parse from DescribeVsDomainTrafficData response
func CreateDescribeVsDomainTrafficDataResponse() (response *DescribeVsDomainTrafficDataResponse) {
	response = &DescribeVsDomainTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
