package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopAdjust invokes the vs.StopAdjust API synchronously
func (client *Client) StopAdjust(request *StopAdjustRequest) (response *StopAdjustResponse, err error) {
	response = CreateStopAdjustResponse()
	err = client.DoAction(request, response)
	return
}

// StopAdjustWithChan invokes the vs.StopAdjust API asynchronously
func (client *Client) StopAdjustWithChan(request *StopAdjustRequest) (<-chan *StopAdjustResponse, <-chan error) {
	responseChan := make(chan *StopAdjustResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopAdjust(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopAdjustWithCallback invokes the vs.StopAdjust API asynchronously
func (client *Client) StopAdjustWithCallback(request *StopAdjustRequest, callback func(response *StopAdjustResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopAdjustResponse
		var err error
		defer close(result)
		response, err = client.StopAdjust(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopAdjustRequest is the request struct for api StopAdjust
type StopAdjustRequest struct {
	*requests.RpcRequest
	Focus   requests.Boolean `position:"Query" name:"Focus"`
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	Iris    requests.Boolean `position:"Query" name:"Iris"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// StopAdjustResponse is the response struct for api StopAdjust
type StopAdjustResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateStopAdjustRequest creates a request to invoke StopAdjust API
func CreateStopAdjustRequest() (request *StopAdjustRequest) {
	request = &StopAdjustRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "StopAdjust", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopAdjustResponse creates a response to parse from StopAdjust response
func CreateStopAdjustResponse() (response *StopAdjustResponse) {
	response = &StopAdjustResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
