package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVsPullStreamInfoConfig invokes the vs.UpdateVsPullStreamInfoConfig API synchronously
func (client *Client) UpdateVsPullStreamInfoConfig(request *UpdateVsPullStreamInfoConfigRequest) (response *UpdateVsPullStreamInfoConfigResponse, err error) {
	response = CreateUpdateVsPullStreamInfoConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVsPullStreamInfoConfigWithChan invokes the vs.UpdateVsPullStreamInfoConfig API asynchronously
func (client *Client) UpdateVsPullStreamInfoConfigWithChan(request *UpdateVsPullStreamInfoConfigRequest) (<-chan *UpdateVsPullStreamInfoConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateVsPullStreamInfoConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVsPullStreamInfoConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVsPullStreamInfoConfigWithCallback invokes the vs.UpdateVsPullStreamInfoConfig API asynchronously
func (client *Client) UpdateVsPullStreamInfoConfigWithCallback(request *UpdateVsPullStreamInfoConfigRequest, callback func(response *UpdateVsPullStreamInfoConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVsPullStreamInfoConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateVsPullStreamInfoConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVsPullStreamInfoConfigRequest is the request struct for api UpdateVsPullStreamInfoConfig
type UpdateVsPullStreamInfoConfigRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	Always     string           `position:"Query" name:"Always"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	SourceUrl  string           `position:"Query" name:"SourceUrl"`
}

// UpdateVsPullStreamInfoConfigResponse is the response struct for api UpdateVsPullStreamInfoConfig
type UpdateVsPullStreamInfoConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateVsPullStreamInfoConfigRequest creates a request to invoke UpdateVsPullStreamInfoConfig API
func CreateUpdateVsPullStreamInfoConfigRequest() (request *UpdateVsPullStreamInfoConfigRequest) {
	request = &UpdateVsPullStreamInfoConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UpdateVsPullStreamInfoConfig", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVsPullStreamInfoConfigResponse creates a response to parse from UpdateVsPullStreamInfoConfig response
func CreateUpdateVsPullStreamInfoConfigResponse() (response *UpdateVsPullStreamInfoConfigResponse) {
	response = &UpdateVsPullStreamInfoConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
