package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyProtectionModuleRule invokes the waf_openapi.ModifyProtectionModuleRule API synchronously
func (client *Client) ModifyProtectionModuleRule(request *ModifyProtectionModuleRuleRequest) (response *ModifyProtectionModuleRuleResponse, err error) {
	response = CreateModifyProtectionModuleRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyProtectionModuleRuleWithChan invokes the waf_openapi.ModifyProtectionModuleRule API asynchronously
func (client *Client) ModifyProtectionModuleRuleWithChan(request *ModifyProtectionModuleRuleRequest) (<-chan *ModifyProtectionModuleRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyProtectionModuleRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyProtectionModuleRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyProtectionModuleRuleWithCallback invokes the waf_openapi.ModifyProtectionModuleRule API asynchronously
func (client *Client) ModifyProtectionModuleRuleWithCallback(request *ModifyProtectionModuleRuleRequest, callback func(response *ModifyProtectionModuleRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyProtectionModuleRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyProtectionModuleRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyProtectionModuleRuleRequest is the request struct for api ModifyProtectionModuleRule
type ModifyProtectionModuleRuleRequest struct {
	*requests.RpcRequest
	Rule        string           `position:"Query" name:"Rule"`
	LockVersion requests.Integer `position:"Query" name:"LockVersion"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Lang        string           `position:"Query" name:"Lang"`
	DefenseType string           `position:"Query" name:"DefenseType"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	Domain      string           `position:"Query" name:"Domain"`
	RuleId      requests.Integer `position:"Query" name:"RuleId"`
}

// ModifyProtectionModuleRuleResponse is the response struct for api ModifyProtectionModuleRule
type ModifyProtectionModuleRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyProtectionModuleRuleRequest creates a request to invoke ModifyProtectionModuleRule API
func CreateModifyProtectionModuleRuleRequest() (request *ModifyProtectionModuleRuleRequest) {
	request = &ModifyProtectionModuleRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "ModifyProtectionModuleRule", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyProtectionModuleRuleResponse creates a response to parse from ModifyProtectionModuleRule response
func CreateModifyProtectionModuleRuleResponse() (response *ModifyProtectionModuleRuleResponse) {
	response = &ModifyProtectionModuleRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
