package policyinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// PolicyStatesResource enumerates the values for policy states resource.
type PolicyStatesResource string

const (
	// Default ...
	Default PolicyStatesResource = "default"
	// Latest ...
	Latest PolicyStatesResource = "latest"
)

// PossiblePolicyStatesResourceValues returns an array of possible values for the PolicyStatesResource const type.
func PossiblePolicyStatesResourceValues() []PolicyStatesResource {
	return []PolicyStatesResource{Default, Latest}
}

// ResourceDiscoveryMode enumerates the values for resource discovery mode.
type ResourceDiscoveryMode string

const (
	// ExistingNonCompliant Remediate resources that are already known to be non-compliant.
	ExistingNonCompliant ResourceDiscoveryMode = "ExistingNonCompliant"
	// ReEvaluateCompliance Re-evaluate the compliance state of resources and then remediate the resources
	// found to be non-compliant.
	ReEvaluateCompliance ResourceDiscoveryMode = "ReEvaluateCompliance"
)

// PossibleResourceDiscoveryModeValues returns an array of possible values for the ResourceDiscoveryMode const type.
func PossibleResourceDiscoveryModeValues() []ResourceDiscoveryMode {
	return []ResourceDiscoveryMode{ExistingNonCompliant, ReEvaluateCompliance}
}
