package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySettleBill invokes the bssopenapi.QuerySettleBill API synchronously
func (client *Client) QuerySettleBill(request *QuerySettleBillRequest) (response *QuerySettleBillResponse, err error) {
	response = CreateQuerySettleBillResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySettleBillWithChan invokes the bssopenapi.QuerySettleBill API asynchronously
func (client *Client) QuerySettleBillWithChan(request *QuerySettleBillRequest) (<-chan *QuerySettleBillResponse, <-chan error) {
	responseChan := make(chan *QuerySettleBillResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySettleBill(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySettleBillWithCallback invokes the bssopenapi.QuerySettleBill API asynchronously
func (client *Client) QuerySettleBillWithCallback(request *QuerySettleBillRequest, callback func(response *QuerySettleBillResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySettleBillResponse
		var err error
		defer close(result)
		response, err = client.QuerySettleBill(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySettleBillRequest is the request struct for api QuerySettleBill
type QuerySettleBillRequest struct {
	*requests.RpcRequest
	ProductCode            string           `position:"Query" name:"ProductCode"`
	IsHideZeroCharge       requests.Boolean `position:"Query" name:"IsHideZeroCharge"`
	IsDisplayLocalCurrency requests.Boolean `position:"Query" name:"IsDisplayLocalCurrency"`
	SubscriptionType       string           `position:"Query" name:"SubscriptionType"`
	BillingCycle           string           `position:"Query" name:"BillingCycle"`
	Type                   string           `position:"Query" name:"Type"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	BillOwnerId            requests.Integer `position:"Query" name:"BillOwnerId"`
	ProductType            string           `position:"Query" name:"ProductType"`
	RecordID               string           `position:"Query" name:"RecordID"`
	NextToken              string           `position:"Query" name:"NextToken"`
	MaxResults             requests.Integer `position:"Query" name:"MaxResults"`
}

// QuerySettleBillResponse is the response struct for api QuerySettleBill
type QuerySettleBillResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Success   bool                  `json:"Success" xml:"Success"`
	Code      string                `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	Data      DataInQuerySettleBill `json:"Data" xml:"Data"`
}

// CreateQuerySettleBillRequest creates a request to invoke QuerySettleBill API
func CreateQuerySettleBillRequest() (request *QuerySettleBillRequest) {
	request = &QuerySettleBillRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QuerySettleBill", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySettleBillResponse creates a response to parse from QuerySettleBill response
func CreateQuerySettleBillResponse() (response *QuerySettleBillResponse) {
	response = &QuerySettleBillResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
