package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePortAttackMaxFlow invokes the ddoscoo.DescribePortAttackMaxFlow API synchronously
func (client *Client) DescribePortAttackMaxFlow(request *DescribePortAttackMaxFlowRequest) (response *DescribePortAttackMaxFlowResponse, err error) {
	response = CreateDescribePortAttackMaxFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePortAttackMaxFlowWithChan invokes the ddoscoo.DescribePortAttackMaxFlow API asynchronously
func (client *Client) DescribePortAttackMaxFlowWithChan(request *DescribePortAttackMaxFlowRequest) (<-chan *DescribePortAttackMaxFlowResponse, <-chan error) {
	responseChan := make(chan *DescribePortAttackMaxFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePortAttackMaxFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePortAttackMaxFlowWithCallback invokes the ddoscoo.DescribePortAttackMaxFlow API asynchronously
func (client *Client) DescribePortAttackMaxFlowWithCallback(request *DescribePortAttackMaxFlowRequest, callback func(response *DescribePortAttackMaxFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePortAttackMaxFlowResponse
		var err error
		defer close(result)
		response, err = client.DescribePortAttackMaxFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePortAttackMaxFlowRequest is the request struct for api DescribePortAttackMaxFlow
type DescribePortAttackMaxFlowRequest struct {
	*requests.RpcRequest
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
}

// DescribePortAttackMaxFlowResponse is the response struct for api DescribePortAttackMaxFlow
type DescribePortAttackMaxFlowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Bps       int64  `json:"Bps" xml:"Bps"`
	Pps       int64  `json:"Pps" xml:"Pps"`
}

// CreateDescribePortAttackMaxFlowRequest creates a request to invoke DescribePortAttackMaxFlow API
func CreateDescribePortAttackMaxFlowRequest() (request *DescribePortAttackMaxFlowRequest) {
	request = &DescribePortAttackMaxFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribePortAttackMaxFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePortAttackMaxFlowResponse creates a response to parse from DescribePortAttackMaxFlow response
func CreateDescribePortAttackMaxFlowResponse() (response *DescribePortAttackMaxFlowResponse) {
	response = &DescribePortAttackMaxFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
