package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteK8sIngressRule invokes the edas.DeleteK8sIngressRule API synchronously
func (client *Client) DeleteK8sIngressRule(request *DeleteK8sIngressRuleRequest) (response *DeleteK8sIngressRuleResponse, err error) {
	response = CreateDeleteK8sIngressRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteK8sIngressRuleWithChan invokes the edas.DeleteK8sIngressRule API asynchronously
func (client *Client) DeleteK8sIngressRuleWithChan(request *DeleteK8sIngressRuleRequest) (<-chan *DeleteK8sIngressRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteK8sIngressRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteK8sIngressRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteK8sIngressRuleWithCallback invokes the edas.DeleteK8sIngressRule API asynchronously
func (client *Client) DeleteK8sIngressRuleWithCallback(request *DeleteK8sIngressRuleRequest, callback func(response *DeleteK8sIngressRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteK8sIngressRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteK8sIngressRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteK8sIngressRuleRequest is the request struct for api DeleteK8sIngressRule
type DeleteK8sIngressRuleRequest struct {
	*requests.RoaRequest
	Namespace string `position:"Query" name:"Namespace"`
	Name      string `position:"Query" name:"Name"`
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DeleteK8sIngressRuleResponse is the response struct for api DeleteK8sIngressRule
type DeleteK8sIngressRuleResponse struct {
	*responses.BaseResponse
	Code    int    `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateDeleteK8sIngressRuleRequest creates a request to invoke DeleteK8sIngressRule API
func CreateDeleteK8sIngressRuleRequest() (request *DeleteK8sIngressRuleRequest) {
	request = &DeleteK8sIngressRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteK8sIngressRule", "/pop/v5/k8s/acs/k8s_ingress", "Edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteK8sIngressRuleResponse creates a response to parse from DeleteK8sIngressRule response
func CreateDeleteK8sIngressRuleResponse() (response *DeleteK8sIngressRuleResponse) {
	response = &DeleteK8sIngressRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
