package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobOutputStatisticInfo invokes the emr.GetJobOutputStatisticInfo API synchronously
func (client *Client) GetJobOutputStatisticInfo(request *GetJobOutputStatisticInfoRequest) (response *GetJobOutputStatisticInfoResponse, err error) {
	response = CreateGetJobOutputStatisticInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobOutputStatisticInfoWithChan invokes the emr.GetJobOutputStatisticInfo API asynchronously
func (client *Client) GetJobOutputStatisticInfoWithChan(request *GetJobOutputStatisticInfoRequest) (<-chan *GetJobOutputStatisticInfoResponse, <-chan error) {
	responseChan := make(chan *GetJobOutputStatisticInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobOutputStatisticInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobOutputStatisticInfoWithCallback invokes the emr.GetJobOutputStatisticInfo API asynchronously
func (client *Client) GetJobOutputStatisticInfoWithCallback(request *GetJobOutputStatisticInfoRequest, callback func(response *GetJobOutputStatisticInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobOutputStatisticInfoResponse
		var err error
		defer close(result)
		response, err = client.GetJobOutputStatisticInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobOutputStatisticInfoRequest is the request struct for api GetJobOutputStatisticInfo
type GetJobOutputStatisticInfoRequest struct {
	*requests.RpcRequest
	FromDatetime    string           `position:"Query" name:"FromDatetime"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ToDatetime      string           `position:"Query" name:"ToDatetime"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// GetJobOutputStatisticInfoResponse is the response struct for api GetJobOutputStatisticInfo
type GetJobOutputStatisticInfoResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Total         int           `json:"Total" xml:"Total"`
	PageNumber    int           `json:"PageNumber" xml:"PageNumber"`
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	JobOutputList JobOutputList `json:"JobOutputList" xml:"JobOutputList"`
}

// CreateGetJobOutputStatisticInfoRequest creates a request to invoke GetJobOutputStatisticInfo API
func CreateGetJobOutputStatisticInfoRequest() (request *GetJobOutputStatisticInfoRequest) {
	request = &GetJobOutputStatisticInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetJobOutputStatisticInfo", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetJobOutputStatisticInfoResponse creates a response to parse from GetJobOutputStatisticInfo response
func CreateGetJobOutputStatisticInfoResponse() (response *GetJobOutputStatisticInfoResponse) {
	response = &GetJobOutputStatisticInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
