package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserSubmissionStatisticInfo invokes the emr.GetUserSubmissionStatisticInfo API synchronously
func (client *Client) GetUserSubmissionStatisticInfo(request *GetUserSubmissionStatisticInfoRequest) (response *GetUserSubmissionStatisticInfoResponse, err error) {
	response = CreateGetUserSubmissionStatisticInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserSubmissionStatisticInfoWithChan invokes the emr.GetUserSubmissionStatisticInfo API asynchronously
func (client *Client) GetUserSubmissionStatisticInfoWithChan(request *GetUserSubmissionStatisticInfoRequest) (<-chan *GetUserSubmissionStatisticInfoResponse, <-chan error) {
	responseChan := make(chan *GetUserSubmissionStatisticInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserSubmissionStatisticInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserSubmissionStatisticInfoWithCallback invokes the emr.GetUserSubmissionStatisticInfo API asynchronously
func (client *Client) GetUserSubmissionStatisticInfoWithCallback(request *GetUserSubmissionStatisticInfoRequest, callback func(response *GetUserSubmissionStatisticInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserSubmissionStatisticInfoResponse
		var err error
		defer close(result)
		response, err = client.GetUserSubmissionStatisticInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserSubmissionStatisticInfoRequest is the request struct for api GetUserSubmissionStatisticInfo
type GetUserSubmissionStatisticInfoRequest struct {
	*requests.RpcRequest
	FromDatetime    string           `position:"Query" name:"FromDatetime"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ToDatetime      string           `position:"Query" name:"ToDatetime"`
	FinalStatus     string           `position:"Query" name:"FinalStatus"`
	ApplicationType string           `position:"Query" name:"ApplicationType"`
}

// GetUserSubmissionStatisticInfoResponse is the response struct for api GetUserSubmissionStatisticInfo
type GetUserSubmissionStatisticInfoResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	UserSubmissionList UserSubmissionList `json:"UserSubmissionList" xml:"UserSubmissionList"`
}

// CreateGetUserSubmissionStatisticInfoRequest creates a request to invoke GetUserSubmissionStatisticInfo API
func CreateGetUserSubmissionStatisticInfoRequest() (request *GetUserSubmissionStatisticInfoRequest) {
	request = &GetUserSubmissionStatisticInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetUserSubmissionStatisticInfo", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserSubmissionStatisticInfoResponse creates a response to parse from GetUserSubmissionStatisticInfo response
func CreateGetUserSubmissionStatisticInfoResponse() (response *GetUserSubmissionStatisticInfoResponse) {
	response = &GetUserSubmissionStatisticInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
