---
layout: "docs"
page_title: "Upgrading to Vault 0.9.0 - Guides"
sidebar_title: "Upgrade to 0.9.0"
sidebar_current: "docs-upgrading-to-0.9.0"
description: |-
  This page contains the list of deprecations and important or breaking changes
  for Vault 0.9.0. Please read it carefully.
---

# Overview

This page contains the list of deprecations and important or breaking changes
for Vault 0.9.0 compared to the most recent release. Please read it carefully.

### PKI Root Generation (Since 0.8.1)

Calling [`pki/root/generate`][generate-root] when a CA cert/key already exists will now return a
`204` instead of overwriting an existing root. If you want to recreate the
root, first run a delete operation on `pki/root` (requires `sudo` capability),
then generate it again.

### Token Period in AWS IAM Auth (Since 0.8.2)

In prior versions of Vault, if authenticating via AWS IAM and requesting a
periodic token, the period was not properly respected. This could lead to
tokens expiring unexpectedly, or a token lifetime being longer than expected.
Upon token renewal with Vault 0.8.2 the period will be properly enforced.

### SSH CLI Parameters (Since 0.8.2)

`vault ssh` users should supply `-mode` and `-role` to reduce the number of API
calls. A future version of Vault will mark these optional values are required.
Failure to supply `-mode` or `-role` will result in a warning.

### Vault Plugin Init (Since 0.8.2)

Vault plugins will first briefly run a restricted version of the plugin to
fetch metadata, and then lazy-load the plugin on first request to prevent
crash/deadlock of Vault during the unseal process. Plugins will need to be
built with the latest changes in order for them to run properly.

### Policy Input Format Standardization (Since 0.8.3)

For all built-in authentication backends, policies can now be specified as a
comma-delimited string or an array if using JSON as API input; on read,
policies will be returned as an array; and the `default` policy will not be
forcefully added to policies saved in configurations. Please note that the
`default` policy will continue to be added to generated tokens, however, rather
than backends adding `default` to the given set of input policies (in some
cases, and not in others), the stored set will reflect the user-specified set.

### PKI `sign-self-issued` modifies `Issuer` in generated certificates (Since 0.8.3)

In 0.8.2 the endpoint would not modify the Issuer in the generated certificate,
leaving the output self-issued. Although theoretically valid, in practice
crypto stacks were unhappy validating paths containing such certs. As a result,
`sign-self-issued` now encodes the signing CA's Subject DN into the Issuer DN
of the generated certificate.

### `sys/raw` requires enabling (Since 0.8.3)

While the `sys/raw` endpoint can be extremely useful in break-glass or support
scenarios, it is also extremely dangerous.  As of now, a configuration file
option `raw_storage_endpoint` must be set in order to enable this API endpoint.
Once set, the available functionality has been enhanced slightly; it now
supports listing and decrypting most of Vault's core data structures, except
for the encryption keyring itself.

### `generic` is now `kv` (Since 0.8.3)

To better reflect its actual use, the `generic` backend is now `kv`. Using
`generic` will still work for backwards compatibility.

### HSM Users Need to Specify New Config Options (In 0.9)

When using Vault with an HSM, a new parameter is required: `hmac_key_label`.
This performs a similar function to `key_label` but for the HMAC key Vault will
use. Vault will generate a suitable key if this value is specified and
`generate_key` is set true. See [the seal configuration page][pkcs11-seal] for
more information.

### API HTTP client behavior (In 0.9)

When calling `NewClient` the API no longer modifies the provided
client/transport. In particular this means it will no longer enable redirection
limiting and HTTP/2 support on custom clients. It is suggested that if you want
to make changes to an HTTP client that you use one created by `DefaultConfig`
as a starting point.

### AWS EC2 client nonce behavior (In 0.9)

The client nonce generated by the backend that gets returned along with the
authentication response will be audited in plaintext. If this is undesired, the
clients can choose to supply a custom nonce to the login endpoint. The custom
nonce set by the client will from now on, not be returned back with the
authentication response, and hence not audit logged.

### AWS Auth role options (In 0.9)

The API will now error when trying to create or update a role with the
mutually-exclusive options `disallow_reauthentication` and
`allow_instance_migration`.

### SSH CA role read changes (In 0.9)

When reading back a role from the `ssh` backend, the TTL/max TTL values will
now be an integer number of seconds rather than a string. This better matches
the API elsewhere in Vault.

### SSH role list changes (In 0.9)

When listing roles from the `ssh` backend via the API, the response data will
additionally return a `key_info` map that will contain a map of each key with a
corresponding object containing the `key_type`.

### More granularity in audit logs (In 0.9)

Audit request and response entries are still in RFC3339 format but now have a
granularity of nanoseconds.

[generate-root]: https://www.vaultproject.io/api/secret/pki/index.html#generate-root
[pkcs11-seal]: https://www.vaultproject.io/docs/configuration/seal/pkcs11.html
