# IBM COS Resource Configuration SDK for Go

This package allows Go developers to write software that interacts with the Resource Configuration API for [IBM
Cloud Object Storage](https://cloud.ibm.com/apidocs/cos/cos-configuration).

## Documentation

* [Core documentation for IBM COS](https://cloud.ibm.com/docs/services/cloud-object-storage/getting-started.html)
* [REST API Reference and Code Examples](https://cloud.ibm.com/apidocs/cos/cos-configuration)
* [Go Resource Configuration API reference documentation](https://pkg.go.dev/github.com/IBM/ibm-cos-sdk-go-config)

For release notes, see the [CHANGELOG][changes-file].

## Quick start

You'll need:

* An instance of COS.
* An API key from [IBM Cloud Identity and Access Management](https://cloud.ibm.com/docs/iam/users_roles.html).
* Minimum version of Go 1.12.

## Getting the SDK

Get SDK package:

```shell
go get -u github.com/IBM/ibm-cos-sdk-go-config/...
```

## Getting help

Feel free to use GitHub issues for tracking bugs and feature requests, but for help please use one of the following resources:

* Read a quick start guide in [IBM Cloud Docs][bluemix-docs]
* Ask a question on [StackOverflow][stack-overflow] and tag it with `ibm` and `object-storage`
* Open a support ticket with [IBM Cloud Support][ibm-bluemix-support]
* If it turns out that you may have found a bug, please [open an issue][open-an-issue]

[changes-file]: ./CHANGELOG.md
[bluemix-docs]: https://cloud.ibm.com/docs/services/cloud-object-storage/
[stack-overflow]: http://stackoverflow.com/questions/tagged/object-storage+ibm
[ibm-bluemix-support]: https://cloud.ibm.com/unifiedsupport/supportcenter
[open-an-issue]: https://github.com/ibm/ibm-cos-sdk-go-config/issues/new

## License

This SDK is distributed under the
[Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0).
