package accesscontrolapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/synapse/2020-08-01-preview/accesscontrol"
	"github.com/Azure/go-autorest/autorest"
)

// RoleAssignmentsClientAPI contains the set of methods on the RoleAssignmentsClient type.
type RoleAssignmentsClientAPI interface {
	CheckPrincipalAccess(ctx context.Context, request accesscontrol.CheckPrincipalAccessRequest) (result accesscontrol.CheckPrincipalAccessResponse, err error)
	CreateRoleAssignment(ctx context.Context, request accesscontrol.RoleAssignmentRequest, roleAssignmentID string) (result accesscontrol.RoleAssignmentDetails, err error)
	DeleteRoleAssignmentByID(ctx context.Context, roleAssignmentID string, scope string) (result autorest.Response, err error)
	GetRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result accesscontrol.RoleAssignmentDetails, err error)
	ListRoleAssignments(ctx context.Context, roleID string, principalID string, scope string, continuationToken string) (result accesscontrol.RoleAssignmentDetailsList, err error)
}

var _ RoleAssignmentsClientAPI = (*accesscontrol.RoleAssignmentsClient)(nil)

// RoleDefinitionsClientAPI contains the set of methods on the RoleDefinitionsClient type.
type RoleDefinitionsClientAPI interface {
	GetRoleDefinitionByID(ctx context.Context, roleDefinitionID string) (result accesscontrol.SynapseRoleDefinition, err error)
	ListRoleDefinitions(ctx context.Context, isBuiltIn *bool, scope string) (result accesscontrol.ListSynapseRoleDefinition, err error)
	ListScopes(ctx context.Context) (result accesscontrol.ListString, err error)
}

var _ RoleDefinitionsClientAPI = (*accesscontrol.RoleDefinitionsClient)(nil)
