// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to the get project operation.
type GetProjectInput struct {
	_ struct{} `type:"structure"`

	// The project's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetProjectInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the result of a get project request.
type GetProjectOutput struct {
	_ struct{} `type:"structure"`

	// The project you wish to get information about.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s GetProjectOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetProject = "GetProject"

// GetProjectRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Gets information about a project.
//
//    // Example sending a request using GetProjectRequest.
//    req := client.GetProjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject
func (c *Client) GetProjectRequest(input *GetProjectInput) GetProjectRequest {
	op := &aws.Operation{
		Name:       opGetProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProjectInput{}
	}

	req := c.newRequest(op, input, &GetProjectOutput{})
	return GetProjectRequest{Request: req, Input: input, Copy: c.GetProjectRequest}
}

// GetProjectRequest is the request type for the
// GetProject API operation.
type GetProjectRequest struct {
	*aws.Request
	Input *GetProjectInput
	Copy  func(*GetProjectInput) GetProjectRequest
}

// Send marshals and sends the GetProject API request.
func (r GetProjectRequest) Send(ctx context.Context) (*GetProjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetProjectResponse{
		GetProjectOutput: r.Request.Data.(*GetProjectOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetProjectResponse is the response type for the
// GetProject API operation.
type GetProjectResponse struct {
	*GetProjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetProject request.
func (r *GetProjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
