package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCnameReuse invokes the ddoscoo.ModifyCnameReuse API synchronously
func (client *Client) ModifyCnameReuse(request *ModifyCnameReuseRequest) (response *ModifyCnameReuseResponse, err error) {
	response = CreateModifyCnameReuseResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCnameReuseWithChan invokes the ddoscoo.ModifyCnameReuse API asynchronously
func (client *Client) ModifyCnameReuseWithChan(request *ModifyCnameReuseRequest) (<-chan *ModifyCnameReuseResponse, <-chan error) {
	responseChan := make(chan *ModifyCnameReuseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCnameReuse(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCnameReuseWithCallback invokes the ddoscoo.ModifyCnameReuse API asynchronously
func (client *Client) ModifyCnameReuseWithCallback(request *ModifyCnameReuseRequest, callback func(response *ModifyCnameReuseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCnameReuseResponse
		var err error
		defer close(result)
		response, err = client.ModifyCnameReuse(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCnameReuseRequest is the request struct for api ModifyCnameReuse
type ModifyCnameReuseRequest struct {
	*requests.RpcRequest
	Cname           string           `position:"Query" name:"Cname"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Enable          requests.Integer `position:"Query" name:"Enable"`
	Domain          string           `position:"Query" name:"Domain"`
}

// ModifyCnameReuseResponse is the response struct for api ModifyCnameReuse
type ModifyCnameReuseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCnameReuseRequest creates a request to invoke ModifyCnameReuse API
func CreateModifyCnameReuseRequest() (request *ModifyCnameReuseRequest) {
	request = &ModifyCnameReuseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyCnameReuse", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyCnameReuseResponse creates a response to parse from ModifyCnameReuse response
func CreateModifyCnameReuseResponse() (response *ModifyCnameReuseResponse) {
	response = &ModifyCnameReuseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
