package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSkillGroupsToUser invokes the ccc.AddSkillGroupsToUser API synchronously
func (client *Client) AddSkillGroupsToUser(request *AddSkillGroupsToUserRequest) (response *AddSkillGroupsToUserResponse, err error) {
	response = CreateAddSkillGroupsToUserResponse()
	err = client.DoAction(request, response)
	return
}

// AddSkillGroupsToUserWithChan invokes the ccc.AddSkillGroupsToUser API asynchronously
func (client *Client) AddSkillGroupsToUserWithChan(request *AddSkillGroupsToUserRequest) (<-chan *AddSkillGroupsToUserResponse, <-chan error) {
	responseChan := make(chan *AddSkillGroupsToUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSkillGroupsToUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSkillGroupsToUserWithCallback invokes the ccc.AddSkillGroupsToUser API asynchronously
func (client *Client) AddSkillGroupsToUserWithCallback(request *AddSkillGroupsToUserRequest, callback func(response *AddSkillGroupsToUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSkillGroupsToUserResponse
		var err error
		defer close(result)
		response, err = client.AddSkillGroupsToUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSkillGroupsToUserRequest is the request struct for api AddSkillGroupsToUser
type AddSkillGroupsToUserRequest struct {
	*requests.RpcRequest
	UserId         string `position:"Query" name:"UserId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	SkillLevelList string `position:"Query" name:"SkillLevelList"`
}

// AddSkillGroupsToUserResponse is the response struct for api AddSkillGroupsToUser
type AddSkillGroupsToUserResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
}

// CreateAddSkillGroupsToUserRequest creates a request to invoke AddSkillGroupsToUser API
func CreateAddSkillGroupsToUserRequest() (request *AddSkillGroupsToUserRequest) {
	request = &AddSkillGroupsToUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "AddSkillGroupsToUser", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddSkillGroupsToUserResponse creates a response to parse from AddSkillGroupsToUser response
func CreateAddSkillGroupsToUserResponse() (response *AddSkillGroupsToUserResponse) {
	response = &AddSkillGroupsToUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
