package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCdrsMonitor invokes the cdrs.UpdateCdrsMonitor API synchronously
func (client *Client) UpdateCdrsMonitor(request *UpdateCdrsMonitorRequest) (response *UpdateCdrsMonitorResponse, err error) {
	response = CreateUpdateCdrsMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCdrsMonitorWithChan invokes the cdrs.UpdateCdrsMonitor API asynchronously
func (client *Client) UpdateCdrsMonitorWithChan(request *UpdateCdrsMonitorRequest) (<-chan *UpdateCdrsMonitorResponse, <-chan error) {
	responseChan := make(chan *UpdateCdrsMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCdrsMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCdrsMonitorWithCallback invokes the cdrs.UpdateCdrsMonitor API asynchronously
func (client *Client) UpdateCdrsMonitorWithCallback(request *UpdateCdrsMonitorRequest, callback func(response *UpdateCdrsMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCdrsMonitorResponse
		var err error
		defer close(result)
		response, err = client.UpdateCdrsMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCdrsMonitorRequest is the request struct for api UpdateCdrsMonitor
type UpdateCdrsMonitorRequest struct {
	*requests.RpcRequest
	CorpId               string           `position:"Body" name:"CorpId"`
	Description          string           `position:"Body" name:"Description"`
	RuleName             string           `position:"Body" name:"RuleName"`
	PicOperateType       string           `position:"Body" name:"PicOperateType"`
	AttributeName        string           `position:"Body" name:"AttributeName"`
	AttributeOperateType string           `position:"Body" name:"AttributeOperateType"`
	RuleExpression       string           `position:"Body" name:"RuleExpression"`
	NotifierTimeOut      requests.Integer `position:"Body" name:"NotifierTimeOut"`
	TaskId               string           `position:"Body" name:"TaskId"`
	DeviceOperateType    string           `position:"Body" name:"DeviceOperateType"`
	PicList              string           `position:"Body" name:"PicList"`
	AttributeValueList   string           `position:"Body" name:"AttributeValueList"`
	NotifierAppSecret    string           `position:"Body" name:"NotifierAppSecret"`
	NotifierExtendValues string           `position:"Body" name:"NotifierExtendValues"`
	DeviceList           string           `position:"Body" name:"DeviceList"`
	NotifierUrl          string           `position:"Body" name:"NotifierUrl"`
	NotifierType         string           `position:"Body" name:"NotifierType"`
	BizId                string           `position:"Body" name:"BizId"`
	AlgorithmVendor      string           `position:"Body" name:"AlgorithmVendor"`
}

// UpdateCdrsMonitorResponse is the response struct for api UpdateCdrsMonitor
type UpdateCdrsMonitorResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCdrsMonitorRequest creates a request to invoke UpdateCdrsMonitor API
func CreateUpdateCdrsMonitorRequest() (request *UpdateCdrsMonitorRequest) {
	request = &UpdateCdrsMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "UpdateCdrsMonitor", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCdrsMonitorResponse creates a response to parse from UpdateCdrsMonitor response
func CreateUpdateCdrsMonitorResponse() (response *UpdateCdrsMonitorResponse) {
	response = &UpdateCdrsMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
