package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApStaStatus invokes the cloudwf.ListApStaStatus API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listapstastatus.html
func (client *Client) ListApStaStatus(request *ListApStaStatusRequest) (response *ListApStaStatusResponse, err error) {
	response = CreateListApStaStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListApStaStatusWithChan invokes the cloudwf.ListApStaStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapstastatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApStaStatusWithChan(request *ListApStaStatusRequest) (<-chan *ListApStaStatusResponse, <-chan error) {
	responseChan := make(chan *ListApStaStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApStaStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApStaStatusWithCallback invokes the cloudwf.ListApStaStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapstastatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApStaStatusWithCallback(request *ListApStaStatusRequest, callback func(response *ListApStaStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApStaStatusResponse
		var err error
		defer close(result)
		response, err = client.ListApStaStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApStaStatusRequest is the request struct for api ListApStaStatus
type ListApStaStatusRequest struct {
	*requests.RpcRequest
	OrderCol       string           `position:"Query" name:"OrderCol"`
	SearchProtocal string           `position:"Query" name:"SearchProtocal"`
	SearchSsid     string           `position:"Query" name:"SearchSsid"`
	SearchIp       string           `position:"Query" name:"SearchIp"`
	Length         requests.Integer `position:"Query" name:"Length"`
	SearchUsername string           `position:"Query" name:"SearchUsername"`
	SearchMac      string           `position:"Query" name:"SearchMac"`
	PageIndex      requests.Integer `position:"Query" name:"PageIndex"`
	Id             requests.Integer `position:"Query" name:"Id"`
	OrderDir       string           `position:"Query" name:"OrderDir"`
}

// ListApStaStatusResponse is the response struct for api ListApStaStatus
type ListApStaStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApStaStatusRequest creates a request to invoke ListApStaStatus API
func CreateListApStaStatusRequest() (request *ListApStaStatusRequest) {
	request = &ListApStaStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApStaStatus", "cloudwf", "openAPI")
	return
}

// CreateListApStaStatusResponse creates a response to parse from ListApStaStatus response
func CreateListApStaStatusResponse() (response *ListApStaStatusResponse) {
	response = &ListApStaStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
