package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPeriodInfo invokes the companyreg.GetPeriodInfo API synchronously
func (client *Client) GetPeriodInfo(request *GetPeriodInfoRequest) (response *GetPeriodInfoResponse, err error) {
	response = CreateGetPeriodInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetPeriodInfoWithChan invokes the companyreg.GetPeriodInfo API asynchronously
func (client *Client) GetPeriodInfoWithChan(request *GetPeriodInfoRequest) (<-chan *GetPeriodInfoResponse, <-chan error) {
	responseChan := make(chan *GetPeriodInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPeriodInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPeriodInfoWithCallback invokes the companyreg.GetPeriodInfo API asynchronously
func (client *Client) GetPeriodInfoWithCallback(request *GetPeriodInfoRequest, callback func(response *GetPeriodInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPeriodInfoResponse
		var err error
		defer close(result)
		response, err = client.GetPeriodInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPeriodInfoRequest is the request struct for api GetPeriodInfo
type GetPeriodInfoRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetPeriodInfoResponse is the response struct for api GetPeriodInfo
type GetPeriodInfoResponse struct {
	*responses.BaseResponse
	EmployeeCount   int             `json:"EmployeeCount" xml:"EmployeeCount"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	TaxSteps        []int           `json:"TaxSteps" xml:"TaxSteps"`
	InvoiceInfo     InvoiceInfo     `json:"InvoiceInfo" xml:"InvoiceInfo"`
	BankSummaryInfo BankSummaryInfo `json:"BankSummaryInfo" xml:"BankSummaryInfo"`
}

// CreateGetPeriodInfoRequest creates a request to invoke GetPeriodInfo API
func CreateGetPeriodInfoRequest() (request *GetPeriodInfoRequest) {
	request = &GetPeriodInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetPeriodInfo", "companyreg", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetPeriodInfoResponse creates a response to parse from GetPeriodInfo response
func CreateGetPeriodInfoResponse() (response *GetPeriodInfoResponse) {
	response = &GetPeriodInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
