package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigurationRecorder invokes the config.DescribeConfigurationRecorder API synchronously
func (client *Client) DescribeConfigurationRecorder(request *DescribeConfigurationRecorderRequest) (response *DescribeConfigurationRecorderResponse, err error) {
	response = CreateDescribeConfigurationRecorderResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigurationRecorderWithChan invokes the config.DescribeConfigurationRecorder API asynchronously
func (client *Client) DescribeConfigurationRecorderWithChan(request *DescribeConfigurationRecorderRequest) (<-chan *DescribeConfigurationRecorderResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigurationRecorderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigurationRecorder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigurationRecorderWithCallback invokes the config.DescribeConfigurationRecorder API asynchronously
func (client *Client) DescribeConfigurationRecorderWithCallback(request *DescribeConfigurationRecorderRequest, callback func(response *DescribeConfigurationRecorderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigurationRecorderResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigurationRecorder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigurationRecorderRequest is the request struct for api DescribeConfigurationRecorder
type DescribeConfigurationRecorderRequest struct {
	*requests.RpcRequest
}

// DescribeConfigurationRecorderResponse is the response struct for api DescribeConfigurationRecorder
type DescribeConfigurationRecorderResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	ConfigurationRecorder ConfigurationRecorder `json:"ConfigurationRecorder" xml:"ConfigurationRecorder"`
}

// CreateDescribeConfigurationRecorderRequest creates a request to invoke DescribeConfigurationRecorder API
func CreateDescribeConfigurationRecorderRequest() (request *DescribeConfigurationRecorderRequest) {
	request = &DescribeConfigurationRecorderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "DescribeConfigurationRecorder", "Config", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeConfigurationRecorderResponse creates a response to parse from DescribeConfigurationRecorder response
func CreateDescribeConfigurationRecorderResponse() (response *DescribeConfigurationRecorderResponse) {
	response = &DescribeConfigurationRecorderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
