package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetChartRepository invokes the cr.GetChartRepository API synchronously
// api document: https://help.aliyun.com/api/cr/getchartrepository.html
func (client *Client) GetChartRepository(request *GetChartRepositoryRequest) (response *GetChartRepositoryResponse, err error) {
	response = CreateGetChartRepositoryResponse()
	err = client.DoAction(request, response)
	return
}

// GetChartRepositoryWithChan invokes the cr.GetChartRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/getchartrepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetChartRepositoryWithChan(request *GetChartRepositoryRequest) (<-chan *GetChartRepositoryResponse, <-chan error) {
	responseChan := make(chan *GetChartRepositoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetChartRepository(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetChartRepositoryWithCallback invokes the cr.GetChartRepository API asynchronously
// api document: https://help.aliyun.com/api/cr/getchartrepository.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetChartRepositoryWithCallback(request *GetChartRepositoryRequest, callback func(response *GetChartRepositoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetChartRepositoryResponse
		var err error
		defer close(result)
		response, err = client.GetChartRepository(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetChartRepositoryRequest is the request struct for api GetChartRepository
type GetChartRepositoryRequest struct {
	*requests.RpcRequest
	InstanceId        string `position:"Query" name:"InstanceId"`
	RepoNamespaceName string `position:"Query" name:"RepoNamespaceName"`
	RepoName          string `position:"Query" name:"RepoName"`
}

// GetChartRepositoryResponse is the response struct for api GetChartRepository
type GetChartRepositoryResponse struct {
	*responses.BaseResponse
	GetChartRepositoryIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                        string `json:"Code" xml:"Code"`
	RequestId                   string `json:"RequestId" xml:"RequestId"`
	InstanceId                  string `json:"InstanceId" xml:"InstanceId"`
	RepoId                      string `json:"RepoId" xml:"RepoId"`
	RepoNamespaceName           string `json:"RepoNamespaceName" xml:"RepoNamespaceName"`
	RepoName                    string `json:"RepoName" xml:"RepoName"`
	RepoStatus                  string `json:"RepoStatus" xml:"RepoStatus"`
	RepoType                    string `json:"RepoType" xml:"RepoType"`
	Summary                     string `json:"Summary" xml:"Summary"`
	CreateTime                  int64  `json:"CreateTime" xml:"CreateTime"`
	ModifiedTime                int64  `json:"ModifiedTime" xml:"ModifiedTime"`
}

// CreateGetChartRepositoryRequest creates a request to invoke GetChartRepository API
func CreateGetChartRepositoryRequest() (request *GetChartRepositoryRequest) {
	request = &GetChartRepositoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetChartRepository", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetChartRepositoryResponse creates a response to parse from GetChartRepository response
func CreateGetChartRepositoryResponse() (response *GetChartRepositoryResponse) {
	response = &GetChartRepositoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
