package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNodesByBaseline invokes the dataworks_public.ListNodesByBaseline API synchronously
func (client *Client) ListNodesByBaseline(request *ListNodesByBaselineRequest) (response *ListNodesByBaselineResponse, err error) {
	response = CreateListNodesByBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// ListNodesByBaselineWithChan invokes the dataworks_public.ListNodesByBaseline API asynchronously
func (client *Client) ListNodesByBaselineWithChan(request *ListNodesByBaselineRequest) (<-chan *ListNodesByBaselineResponse, <-chan error) {
	responseChan := make(chan *ListNodesByBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNodesByBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNodesByBaselineWithCallback invokes the dataworks_public.ListNodesByBaseline API asynchronously
func (client *Client) ListNodesByBaselineWithCallback(request *ListNodesByBaselineRequest, callback func(response *ListNodesByBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNodesByBaselineResponse
		var err error
		defer close(result)
		response, err = client.ListNodesByBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNodesByBaselineRequest is the request struct for api ListNodesByBaseline
type ListNodesByBaselineRequest struct {
	*requests.RpcRequest
	BaselineId requests.Integer `position:"Body" name:"BaselineId"`
}

// ListNodesByBaselineResponse is the response struct for api ListNodesByBaseline
type ListNodesByBaselineResponse struct {
	*responses.BaseResponse
	Success        string     `json:"Success" xml:"Success"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateListNodesByBaselineRequest creates a request to invoke ListNodesByBaseline API
func CreateListNodesByBaselineRequest() (request *ListNodesByBaselineRequest) {
	request = &ListNodesByBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListNodesByBaseline", "", "")
	request.Method = requests.POST
	return
}

// CreateListNodesByBaselineResponse creates a response to parse from ListNodesByBaseline response
func CreateListNodesByBaselineResponse() (response *ListNodesByBaselineResponse) {
	response = &ListNodesByBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
