package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSQLReviewOrder invokes the dms_enterprise.CreateSQLReviewOrder API synchronously
func (client *Client) CreateSQLReviewOrder(request *CreateSQLReviewOrderRequest) (response *CreateSQLReviewOrderResponse, err error) {
	response = CreateCreateSQLReviewOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSQLReviewOrderWithChan invokes the dms_enterprise.CreateSQLReviewOrder API asynchronously
func (client *Client) CreateSQLReviewOrderWithChan(request *CreateSQLReviewOrderRequest) (<-chan *CreateSQLReviewOrderResponse, <-chan error) {
	responseChan := make(chan *CreateSQLReviewOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSQLReviewOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSQLReviewOrderWithCallback invokes the dms_enterprise.CreateSQLReviewOrder API asynchronously
func (client *Client) CreateSQLReviewOrderWithCallback(request *CreateSQLReviewOrderRequest, callback func(response *CreateSQLReviewOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSQLReviewOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateSQLReviewOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSQLReviewOrderRequest is the request struct for api CreateSQLReviewOrder
type CreateSQLReviewOrderRequest struct {
	*requests.RpcRequest
	Tid             requests.Integer          `position:"Query" name:"Tid"`
	Param           CreateSQLReviewOrderParam `position:"Query" name:"Param"  type:"Struct"`
	Comment         string                    `position:"Query" name:"Comment"`
	RelatedUserList *[]string                 `position:"Query" name:"RelatedUserList"  type:"Repeated"`
}

// CreateSQLReviewOrderParam is a repeated param struct in CreateSQLReviewOrderRequest
type CreateSQLReviewOrderParam struct {
	AttachmentKeyList *[]string `name:"AttachmentKeyList" type:"Repeated"`
	ProjectName       string    `name:"ProjectName"`
	DbId              string    `name:"DbId"`
}

// CreateSQLReviewOrderResponse is the response struct for api CreateSQLReviewOrder
type CreateSQLReviewOrderResponse struct {
	*responses.BaseResponse
	RequestId         string  `json:"RequestId" xml:"RequestId"`
	Success           bool    `json:"Success" xml:"Success"`
	ErrorMessage      string  `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode         string  `json:"ErrorCode" xml:"ErrorCode"`
	CreateOrderResult []int64 `json:"CreateOrderResult" xml:"CreateOrderResult"`
}

// CreateCreateSQLReviewOrderRequest creates a request to invoke CreateSQLReviewOrder API
func CreateCreateSQLReviewOrderRequest() (request *CreateSQLReviewOrderRequest) {
	request = &CreateSQLReviewOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateSQLReviewOrder", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSQLReviewOrderResponse creates a response to parse from CreateSQLReviewOrder response
func CreateCreateSQLReviewOrderResponse() (response *CreateSQLReviewOrderResponse) {
	response = &CreateSQLReviewOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
