package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDtsJobPassword invokes the dts.ModifyDtsJobPassword API synchronously
func (client *Client) ModifyDtsJobPassword(request *ModifyDtsJobPasswordRequest) (response *ModifyDtsJobPasswordResponse, err error) {
	response = CreateModifyDtsJobPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDtsJobPasswordWithChan invokes the dts.ModifyDtsJobPassword API asynchronously
func (client *Client) ModifyDtsJobPasswordWithChan(request *ModifyDtsJobPasswordRequest) (<-chan *ModifyDtsJobPasswordResponse, <-chan error) {
	responseChan := make(chan *ModifyDtsJobPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDtsJobPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDtsJobPasswordWithCallback invokes the dts.ModifyDtsJobPassword API asynchronously
func (client *Client) ModifyDtsJobPasswordWithCallback(request *ModifyDtsJobPasswordRequest, callback func(response *ModifyDtsJobPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDtsJobPasswordResponse
		var err error
		defer close(result)
		response, err = client.ModifyDtsJobPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDtsJobPasswordRequest is the request struct for api ModifyDtsJobPassword
type ModifyDtsJobPasswordRequest struct {
	*requests.RpcRequest
	Password string `position:"Query" name:"Password"`
	Endpoint string `position:"Query" name:"Endpoint"`
	DtsJobId string `position:"Query" name:"DtsJobId"`
	UserName string `position:"Query" name:"UserName"`
}

// ModifyDtsJobPasswordResponse is the response struct for api ModifyDtsJobPassword
type ModifyDtsJobPasswordResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateModifyDtsJobPasswordRequest creates a request to invoke ModifyDtsJobPassword API
func CreateModifyDtsJobPasswordRequest() (request *ModifyDtsJobPasswordRequest) {
	request = &ModifyDtsJobPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ModifyDtsJobPassword", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDtsJobPasswordResponse creates a response to parse from ModifyDtsJobPassword response
func CreateModifyDtsJobPasswordResponse() (response *ModifyDtsJobPasswordResponse) {
	response = &ModifyDtsJobPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
