package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateBlackNo invokes the dyplsapi.OperateBlackNo API synchronously
func (client *Client) OperateBlackNo(request *OperateBlackNoRequest) (response *OperateBlackNoResponse, err error) {
	response = CreateOperateBlackNoResponse()
	err = client.DoAction(request, response)
	return
}

// OperateBlackNoWithChan invokes the dyplsapi.OperateBlackNo API asynchronously
func (client *Client) OperateBlackNoWithChan(request *OperateBlackNoRequest) (<-chan *OperateBlackNoResponse, <-chan error) {
	responseChan := make(chan *OperateBlackNoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateBlackNo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateBlackNoWithCallback invokes the dyplsapi.OperateBlackNo API asynchronously
func (client *Client) OperateBlackNoWithCallback(request *OperateBlackNoRequest, callback func(response *OperateBlackNoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateBlackNoResponse
		var err error
		defer close(result)
		response, err = client.OperateBlackNo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateBlackNoRequest is the request struct for api OperateBlackNo
type OperateBlackNoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Tips                 string           `position:"Query" name:"Tips"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	BlackNo              string           `position:"Query" name:"BlackNo"`
	OperateType          string           `position:"Query" name:"OperateType"`
}

// OperateBlackNoResponse is the response struct for api OperateBlackNo
type OperateBlackNoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateBlackNoRequest creates a request to invoke OperateBlackNo API
func CreateOperateBlackNoRequest() (request *OperateBlackNoRequest) {
	request = &OperateBlackNoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "OperateBlackNo", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateBlackNoResponse creates a response to parse from OperateBlackNo response
func CreateOperateBlackNoResponse() (response *OperateBlackNoResponse) {
	response = &OperateBlackNoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
