package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTask invokes the eas.CreateTask API synchronously
// api document: https://help.aliyun.com/api/eas/createtask.html
func (client *Client) CreateTask(request *CreateTaskRequest) (response *CreateTaskResponse, err error) {
	response = CreateCreateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTaskWithChan invokes the eas.CreateTask API asynchronously
// api document: https://help.aliyun.com/api/eas/createtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTaskWithChan(request *CreateTaskRequest) (<-chan *CreateTaskResponse, <-chan error) {
	responseChan := make(chan *CreateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTaskWithCallback invokes the eas.CreateTask API asynchronously
// api document: https://help.aliyun.com/api/eas/createtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTaskWithCallback(request *CreateTaskRequest, callback func(response *CreateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTaskRequest is the request struct for api CreateTask
type CreateTaskRequest struct {
	*requests.RoaRequest
}

// CreateTaskResponse is the response struct for api CreateTask
type CreateTaskResponse struct {
	*responses.BaseResponse
}

// CreateCreateTaskRequest creates a request to invoke CreateTask API
func CreateCreateTaskRequest() (request *CreateTaskRequest) {
	request = &CreateTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "CreateTask", "/api/tasks", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTaskResponse creates a response to parse from CreateTask response
func CreateCreateTaskResponse() (response *CreateTaskResponse) {
	response = &CreateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
