package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustomOcrTemplate invokes the green.DescribeCustomOcrTemplate API synchronously
func (client *Client) DescribeCustomOcrTemplate(request *DescribeCustomOcrTemplateRequest) (response *DescribeCustomOcrTemplateResponse, err error) {
	response = CreateDescribeCustomOcrTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustomOcrTemplateWithChan invokes the green.DescribeCustomOcrTemplate API asynchronously
func (client *Client) DescribeCustomOcrTemplateWithChan(request *DescribeCustomOcrTemplateRequest) (<-chan *DescribeCustomOcrTemplateResponse, <-chan error) {
	responseChan := make(chan *DescribeCustomOcrTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustomOcrTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustomOcrTemplateWithCallback invokes the green.DescribeCustomOcrTemplate API asynchronously
func (client *Client) DescribeCustomOcrTemplateWithCallback(request *DescribeCustomOcrTemplateRequest, callback func(response *DescribeCustomOcrTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustomOcrTemplateResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustomOcrTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustomOcrTemplateRequest is the request struct for api DescribeCustomOcrTemplate
type DescribeCustomOcrTemplateRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Ids      string `position:"Query" name:"Ids"`
}

// DescribeCustomOcrTemplateResponse is the response struct for api DescribeCustomOcrTemplate
type DescribeCustomOcrTemplateResponse struct {
	*responses.BaseResponse
	RequestId       string        `json:"RequestId" xml:"RequestId"`
	TotalCount      int           `json:"TotalCount" xml:"TotalCount"`
	OcrTemplateList []OcrTemplate `json:"OcrTemplateList" xml:"OcrTemplateList"`
}

// CreateDescribeCustomOcrTemplateRequest creates a request to invoke DescribeCustomOcrTemplate API
func CreateDescribeCustomOcrTemplateRequest() (request *DescribeCustomOcrTemplateRequest) {
	request = &DescribeCustomOcrTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "DescribeCustomOcrTemplate", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustomOcrTemplateResponse creates a response to parse from DescribeCustomOcrTemplate response
func CreateDescribeCustomOcrTemplateResponse() (response *DescribeCustomOcrTemplateResponse) {
	response = &DescribeCustomOcrTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
