package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MarkWebsiteScanResult invokes the green.MarkWebsiteScanResult API synchronously
func (client *Client) MarkWebsiteScanResult(request *MarkWebsiteScanResultRequest) (response *MarkWebsiteScanResultResponse, err error) {
	response = CreateMarkWebsiteScanResultResponse()
	err = client.DoAction(request, response)
	return
}

// MarkWebsiteScanResultWithChan invokes the green.MarkWebsiteScanResult API asynchronously
func (client *Client) MarkWebsiteScanResultWithChan(request *MarkWebsiteScanResultRequest) (<-chan *MarkWebsiteScanResultResponse, <-chan error) {
	responseChan := make(chan *MarkWebsiteScanResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MarkWebsiteScanResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MarkWebsiteScanResultWithCallback invokes the green.MarkWebsiteScanResult API asynchronously
func (client *Client) MarkWebsiteScanResultWithCallback(request *MarkWebsiteScanResultRequest, callback func(response *MarkWebsiteScanResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MarkWebsiteScanResultResponse
		var err error
		defer close(result)
		response, err = client.MarkWebsiteScanResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MarkWebsiteScanResultRequest is the request struct for api MarkWebsiteScanResult
type MarkWebsiteScanResultRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Ids      string `position:"Query" name:"Ids"`
	Lang     string `position:"Query" name:"Lang"`
}

// MarkWebsiteScanResultResponse is the response struct for api MarkWebsiteScanResult
type MarkWebsiteScanResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMarkWebsiteScanResultRequest creates a request to invoke MarkWebsiteScanResult API
func CreateMarkWebsiteScanResultRequest() (request *MarkWebsiteScanResultRequest) {
	request = &MarkWebsiteScanResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "MarkWebsiteScanResult", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMarkWebsiteScanResultResponse creates a response to parse from MarkWebsiteScanResult response
func CreateMarkWebsiteScanResultResponse() (response *MarkWebsiteScanResultResponse) {
	response = &MarkWebsiteScanResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
