package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SampleFeedback invokes the green.SampleFeedback API synchronously
func (client *Client) SampleFeedback(request *SampleFeedbackRequest) (response *SampleFeedbackResponse, err error) {
	response = CreateSampleFeedbackResponse()
	err = client.DoAction(request, response)
	return
}

// SampleFeedbackWithChan invokes the green.SampleFeedback API asynchronously
func (client *Client) SampleFeedbackWithChan(request *SampleFeedbackRequest) (<-chan *SampleFeedbackResponse, <-chan error) {
	responseChan := make(chan *SampleFeedbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SampleFeedback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SampleFeedbackWithCallback invokes the green.SampleFeedback API asynchronously
func (client *Client) SampleFeedbackWithCallback(request *SampleFeedbackRequest, callback func(response *SampleFeedbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SampleFeedbackResponse
		var err error
		defer close(result)
		response, err = client.SampleFeedback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SampleFeedbackRequest is the request struct for api SampleFeedback
type SampleFeedbackRequest struct {
	*requests.RoaRequest
}

// SampleFeedbackResponse is the response struct for api SampleFeedback
type SampleFeedbackResponse struct {
	*responses.BaseResponse
}

// CreateSampleFeedbackRequest creates a request to invoke SampleFeedback API
func CreateSampleFeedbackRequest() (request *SampleFeedbackRequest) {
	request = &SampleFeedbackRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2016-12-22", "SampleFeedback", "/sample/feedback", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSampleFeedbackResponse creates a response to parse from SampleFeedback response
func CreateSampleFeedbackResponse() (response *SampleFeedbackResponse) {
	response = &SampleFeedbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
