package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetCasterConfig invokes the live.SetCasterConfig API synchronously
func (client *Client) SetCasterConfig(request *SetCasterConfigRequest) (response *SetCasterConfigResponse, err error) {
	response = CreateSetCasterConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetCasterConfigWithChan invokes the live.SetCasterConfig API asynchronously
func (client *Client) SetCasterConfigWithChan(request *SetCasterConfigRequest) (<-chan *SetCasterConfigResponse, <-chan error) {
	responseChan := make(chan *SetCasterConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetCasterConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetCasterConfigWithCallback invokes the live.SetCasterConfig API asynchronously
func (client *Client) SetCasterConfigWithCallback(request *SetCasterConfigRequest, callback func(response *SetCasterConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetCasterConfigResponse
		var err error
		defer close(result)
		response, err = client.SetCasterConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetCasterConfigRequest is the request struct for api SetCasterConfig
type SetCasterConfigRequest struct {
	*requests.RpcRequest
	ChannelEnable    requests.Integer `position:"Query" name:"ChannelEnable"`
	ProgramEffect    requests.Integer `position:"Query" name:"ProgramEffect"`
	ProgramName      string           `position:"Query" name:"ProgramName"`
	RecordConfig     string           `position:"Query" name:"RecordConfig"`
	UrgentMaterialId string           `position:"Query" name:"UrgentMaterialId"`
	TranscodeConfig  string           `position:"Query" name:"TranscodeConfig"`
	CasterName       string           `position:"Query" name:"CasterName"`
	SideOutputUrl    string           `position:"Query" name:"SideOutputUrl"`
	CasterId         string           `position:"Query" name:"CasterId"`
	DomainName       string           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	Delay            requests.Float   `position:"Query" name:"Delay"`
	CallbackUrl      string           `position:"Query" name:"CallbackUrl"`
}

// SetCasterConfigResponse is the response struct for api SetCasterConfig
type SetCasterConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CasterId  string `json:"CasterId" xml:"CasterId"`
}

// CreateSetCasterConfigRequest creates a request to invoke SetCasterConfig API
func CreateSetCasterConfigRequest() (request *SetCasterConfigRequest) {
	request = &SetCasterConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetCasterConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetCasterConfigResponse creates a response to parse from SetCasterConfig response
func CreateSetCasterConfigResponse() (response *SetCasterConfigResponse) {
	response = &SetCasterConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
