package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataSourceTables invokes the opensearch.ListDataSourceTables API synchronously
func (client *Client) ListDataSourceTables(request *ListDataSourceTablesRequest) (response *ListDataSourceTablesResponse, err error) {
	response = CreateListDataSourceTablesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataSourceTablesWithChan invokes the opensearch.ListDataSourceTables API asynchronously
func (client *Client) ListDataSourceTablesWithChan(request *ListDataSourceTablesRequest) (<-chan *ListDataSourceTablesResponse, <-chan error) {
	responseChan := make(chan *ListDataSourceTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataSourceTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataSourceTablesWithCallback invokes the opensearch.ListDataSourceTables API asynchronously
func (client *Client) ListDataSourceTablesWithCallback(request *ListDataSourceTablesRequest, callback func(response *ListDataSourceTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataSourceTablesResponse
		var err error
		defer close(result)
		response, err = client.ListDataSourceTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataSourceTablesRequest is the request struct for api ListDataSourceTables
type ListDataSourceTablesRequest struct {
	*requests.RoaRequest
	DataSourceType string `position:"Path" name:"dataSourceType"`
	Params         string `position:"Query" name:"params"`
}

// ListDataSourceTablesResponse is the response struct for api ListDataSourceTables
type ListDataSourceTablesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"requestId" xml:"requestId"`
	Result    []string `json:"result" xml:"result"`
}

// CreateListDataSourceTablesRequest creates a request to invoke ListDataSourceTables API
func CreateListDataSourceTablesRequest() (request *ListDataSourceTablesRequest) {
	request = &ListDataSourceTablesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListDataSourceTables", "/v4/openapi/assist/data-sources/[dataSourceType]/tables", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDataSourceTablesResponse creates a response to parse from ListDataSourceTables response
func CreateListDataSourceTablesResponse() (response *ListDataSourceTablesResponse) {
	response = &ListDataSourceTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
