package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenTrafficMirrorService invokes the vpc.OpenTrafficMirrorService API synchronously
func (client *Client) OpenTrafficMirrorService(request *OpenTrafficMirrorServiceRequest) (response *OpenTrafficMirrorServiceResponse, err error) {
	response = CreateOpenTrafficMirrorServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenTrafficMirrorServiceWithChan invokes the vpc.OpenTrafficMirrorService API asynchronously
func (client *Client) OpenTrafficMirrorServiceWithChan(request *OpenTrafficMirrorServiceRequest) (<-chan *OpenTrafficMirrorServiceResponse, <-chan error) {
	responseChan := make(chan *OpenTrafficMirrorServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenTrafficMirrorService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenTrafficMirrorServiceWithCallback invokes the vpc.OpenTrafficMirrorService API asynchronously
func (client *Client) OpenTrafficMirrorServiceWithCallback(request *OpenTrafficMirrorServiceRequest, callback func(response *OpenTrafficMirrorServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenTrafficMirrorServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenTrafficMirrorService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenTrafficMirrorServiceRequest is the request struct for api OpenTrafficMirrorService
type OpenTrafficMirrorServiceRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenTrafficMirrorServiceResponse is the response struct for api OpenTrafficMirrorService
type OpenTrafficMirrorServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateOpenTrafficMirrorServiceRequest creates a request to invoke OpenTrafficMirrorService API
func CreateOpenTrafficMirrorServiceRequest() (request *OpenTrafficMirrorServiceRequest) {
	request = &OpenTrafficMirrorServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "OpenTrafficMirrorService", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenTrafficMirrorServiceResponse creates a response to parse from OpenTrafficMirrorService response
func CreateOpenTrafficMirrorServiceResponse() (response *OpenTrafficMirrorServiceResponse) {
	response = &OpenTrafficMirrorServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
