// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package profileiface provides an interface to enable mocking the Amazon Connect Customer Profiles service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package profileiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/profile"
)

// ProfileAPI provides an interface to enable mocking the
// profile.Profile service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Connect Customer Profiles.
//    func myFunc(svc profileiface.ProfileAPI) bool {
//        // Make svc.AddProfileKey request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := profile.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockProfileClient struct {
//        profileiface.ProfileAPI
//    }
//    func (m *mockProfileClient) AddProfileKey(input *profile.AddProfileKeyInput) (*profile.AddProfileKeyOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockProfileClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ProfileAPI interface {
	AddProfileKey(*profile.AddProfileKeyInput) (*profile.AddProfileKeyOutput, error)
	AddProfileKeyWithContext(aws.Context, *profile.AddProfileKeyInput, ...request.Option) (*profile.AddProfileKeyOutput, error)
	AddProfileKeyRequest(*profile.AddProfileKeyInput) (*request.Request, *profile.AddProfileKeyOutput)

	CreateDomain(*profile.CreateDomainInput) (*profile.CreateDomainOutput, error)
	CreateDomainWithContext(aws.Context, *profile.CreateDomainInput, ...request.Option) (*profile.CreateDomainOutput, error)
	CreateDomainRequest(*profile.CreateDomainInput) (*request.Request, *profile.CreateDomainOutput)

	CreateProfile(*profile.CreateProfileInput) (*profile.CreateProfileOutput, error)
	CreateProfileWithContext(aws.Context, *profile.CreateProfileInput, ...request.Option) (*profile.CreateProfileOutput, error)
	CreateProfileRequest(*profile.CreateProfileInput) (*request.Request, *profile.CreateProfileOutput)

	DeleteDomain(*profile.DeleteDomainInput) (*profile.DeleteDomainOutput, error)
	DeleteDomainWithContext(aws.Context, *profile.DeleteDomainInput, ...request.Option) (*profile.DeleteDomainOutput, error)
	DeleteDomainRequest(*profile.DeleteDomainInput) (*request.Request, *profile.DeleteDomainOutput)

	DeleteIntegration(*profile.DeleteIntegrationInput) (*profile.DeleteIntegrationOutput, error)
	DeleteIntegrationWithContext(aws.Context, *profile.DeleteIntegrationInput, ...request.Option) (*profile.DeleteIntegrationOutput, error)
	DeleteIntegrationRequest(*profile.DeleteIntegrationInput) (*request.Request, *profile.DeleteIntegrationOutput)

	DeleteProfile(*profile.DeleteProfileInput) (*profile.DeleteProfileOutput, error)
	DeleteProfileWithContext(aws.Context, *profile.DeleteProfileInput, ...request.Option) (*profile.DeleteProfileOutput, error)
	DeleteProfileRequest(*profile.DeleteProfileInput) (*request.Request, *profile.DeleteProfileOutput)

	DeleteProfileKey(*profile.DeleteProfileKeyInput) (*profile.DeleteProfileKeyOutput, error)
	DeleteProfileKeyWithContext(aws.Context, *profile.DeleteProfileKeyInput, ...request.Option) (*profile.DeleteProfileKeyOutput, error)
	DeleteProfileKeyRequest(*profile.DeleteProfileKeyInput) (*request.Request, *profile.DeleteProfileKeyOutput)

	DeleteProfileObject(*profile.DeleteProfileObjectInput) (*profile.DeleteProfileObjectOutput, error)
	DeleteProfileObjectWithContext(aws.Context, *profile.DeleteProfileObjectInput, ...request.Option) (*profile.DeleteProfileObjectOutput, error)
	DeleteProfileObjectRequest(*profile.DeleteProfileObjectInput) (*request.Request, *profile.DeleteProfileObjectOutput)

	DeleteProfileObjectType(*profile.DeleteProfileObjectTypeInput) (*profile.DeleteProfileObjectTypeOutput, error)
	DeleteProfileObjectTypeWithContext(aws.Context, *profile.DeleteProfileObjectTypeInput, ...request.Option) (*profile.DeleteProfileObjectTypeOutput, error)
	DeleteProfileObjectTypeRequest(*profile.DeleteProfileObjectTypeInput) (*request.Request, *profile.DeleteProfileObjectTypeOutput)

	GetDomain(*profile.GetDomainInput) (*profile.GetDomainOutput, error)
	GetDomainWithContext(aws.Context, *profile.GetDomainInput, ...request.Option) (*profile.GetDomainOutput, error)
	GetDomainRequest(*profile.GetDomainInput) (*request.Request, *profile.GetDomainOutput)

	GetIntegration(*profile.GetIntegrationInput) (*profile.GetIntegrationOutput, error)
	GetIntegrationWithContext(aws.Context, *profile.GetIntegrationInput, ...request.Option) (*profile.GetIntegrationOutput, error)
	GetIntegrationRequest(*profile.GetIntegrationInput) (*request.Request, *profile.GetIntegrationOutput)

	GetProfileObjectType(*profile.GetProfileObjectTypeInput) (*profile.GetProfileObjectTypeOutput, error)
	GetProfileObjectTypeWithContext(aws.Context, *profile.GetProfileObjectTypeInput, ...request.Option) (*profile.GetProfileObjectTypeOutput, error)
	GetProfileObjectTypeRequest(*profile.GetProfileObjectTypeInput) (*request.Request, *profile.GetProfileObjectTypeOutput)

	GetProfileObjectTypeTemplate(*profile.GetProfileObjectTypeTemplateInput) (*profile.GetProfileObjectTypeTemplateOutput, error)
	GetProfileObjectTypeTemplateWithContext(aws.Context, *profile.GetProfileObjectTypeTemplateInput, ...request.Option) (*profile.GetProfileObjectTypeTemplateOutput, error)
	GetProfileObjectTypeTemplateRequest(*profile.GetProfileObjectTypeTemplateInput) (*request.Request, *profile.GetProfileObjectTypeTemplateOutput)

	ListAccountIntegrations(*profile.ListAccountIntegrationsInput) (*profile.ListAccountIntegrationsOutput, error)
	ListAccountIntegrationsWithContext(aws.Context, *profile.ListAccountIntegrationsInput, ...request.Option) (*profile.ListAccountIntegrationsOutput, error)
	ListAccountIntegrationsRequest(*profile.ListAccountIntegrationsInput) (*request.Request, *profile.ListAccountIntegrationsOutput)

	ListDomains(*profile.ListDomainsInput) (*profile.ListDomainsOutput, error)
	ListDomainsWithContext(aws.Context, *profile.ListDomainsInput, ...request.Option) (*profile.ListDomainsOutput, error)
	ListDomainsRequest(*profile.ListDomainsInput) (*request.Request, *profile.ListDomainsOutput)

	ListIntegrations(*profile.ListIntegrationsInput) (*profile.ListIntegrationsOutput, error)
	ListIntegrationsWithContext(aws.Context, *profile.ListIntegrationsInput, ...request.Option) (*profile.ListIntegrationsOutput, error)
	ListIntegrationsRequest(*profile.ListIntegrationsInput) (*request.Request, *profile.ListIntegrationsOutput)

	ListProfileObjectTypeTemplates(*profile.ListProfileObjectTypeTemplatesInput) (*profile.ListProfileObjectTypeTemplatesOutput, error)
	ListProfileObjectTypeTemplatesWithContext(aws.Context, *profile.ListProfileObjectTypeTemplatesInput, ...request.Option) (*profile.ListProfileObjectTypeTemplatesOutput, error)
	ListProfileObjectTypeTemplatesRequest(*profile.ListProfileObjectTypeTemplatesInput) (*request.Request, *profile.ListProfileObjectTypeTemplatesOutput)

	ListProfileObjectTypes(*profile.ListProfileObjectTypesInput) (*profile.ListProfileObjectTypesOutput, error)
	ListProfileObjectTypesWithContext(aws.Context, *profile.ListProfileObjectTypesInput, ...request.Option) (*profile.ListProfileObjectTypesOutput, error)
	ListProfileObjectTypesRequest(*profile.ListProfileObjectTypesInput) (*request.Request, *profile.ListProfileObjectTypesOutput)

	ListProfileObjects(*profile.ListProfileObjectsInput) (*profile.ListProfileObjectsOutput, error)
	ListProfileObjectsWithContext(aws.Context, *profile.ListProfileObjectsInput, ...request.Option) (*profile.ListProfileObjectsOutput, error)
	ListProfileObjectsRequest(*profile.ListProfileObjectsInput) (*request.Request, *profile.ListProfileObjectsOutput)

	ListTagsForResource(*profile.ListTagsForResourceInput) (*profile.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *profile.ListTagsForResourceInput, ...request.Option) (*profile.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*profile.ListTagsForResourceInput) (*request.Request, *profile.ListTagsForResourceOutput)

	PutIntegration(*profile.PutIntegrationInput) (*profile.PutIntegrationOutput, error)
	PutIntegrationWithContext(aws.Context, *profile.PutIntegrationInput, ...request.Option) (*profile.PutIntegrationOutput, error)
	PutIntegrationRequest(*profile.PutIntegrationInput) (*request.Request, *profile.PutIntegrationOutput)

	PutProfileObject(*profile.PutProfileObjectInput) (*profile.PutProfileObjectOutput, error)
	PutProfileObjectWithContext(aws.Context, *profile.PutProfileObjectInput, ...request.Option) (*profile.PutProfileObjectOutput, error)
	PutProfileObjectRequest(*profile.PutProfileObjectInput) (*request.Request, *profile.PutProfileObjectOutput)

	PutProfileObjectType(*profile.PutProfileObjectTypeInput) (*profile.PutProfileObjectTypeOutput, error)
	PutProfileObjectTypeWithContext(aws.Context, *profile.PutProfileObjectTypeInput, ...request.Option) (*profile.PutProfileObjectTypeOutput, error)
	PutProfileObjectTypeRequest(*profile.PutProfileObjectTypeInput) (*request.Request, *profile.PutProfileObjectTypeOutput)

	SearchProfiles(*profile.SearchProfilesInput) (*profile.SearchProfilesOutput, error)
	SearchProfilesWithContext(aws.Context, *profile.SearchProfilesInput, ...request.Option) (*profile.SearchProfilesOutput, error)
	SearchProfilesRequest(*profile.SearchProfilesInput) (*request.Request, *profile.SearchProfilesOutput)

	TagResource(*profile.TagResourceInput) (*profile.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *profile.TagResourceInput, ...request.Option) (*profile.TagResourceOutput, error)
	TagResourceRequest(*profile.TagResourceInput) (*request.Request, *profile.TagResourceOutput)

	UntagResource(*profile.UntagResourceInput) (*profile.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *profile.UntagResourceInput, ...request.Option) (*profile.UntagResourceOutput, error)
	UntagResourceRequest(*profile.UntagResourceInput) (*request.Request, *profile.UntagResourceOutput)

	UpdateDomain(*profile.UpdateDomainInput) (*profile.UpdateDomainOutput, error)
	UpdateDomainWithContext(aws.Context, *profile.UpdateDomainInput, ...request.Option) (*profile.UpdateDomainOutput, error)
	UpdateDomainRequest(*profile.UpdateDomainInput) (*request.Request, *profile.UpdateDomainOutput)

	UpdateProfile(*profile.UpdateProfileInput) (*profile.UpdateProfileOutput, error)
	UpdateProfileWithContext(aws.Context, *profile.UpdateProfileInput, ...request.Option) (*profile.UpdateProfileOutput, error)
	UpdateProfileRequest(*profile.UpdateProfileInput) (*request.Request, *profile.UpdateProfileOutput)
}

var _ ProfileAPI = (*profile.Profile)(nil)
