package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadOrganizationSDK invokes the baas.DownloadOrganizationSDK API synchronously
// api document: https://help.aliyun.com/api/baas/downloadorganizationsdk.html
func (client *Client) DownloadOrganizationSDK(request *DownloadOrganizationSDKRequest) (response *DownloadOrganizationSDKResponse, err error) {
	response = CreateDownloadOrganizationSDKResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadOrganizationSDKWithChan invokes the baas.DownloadOrganizationSDK API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadorganizationsdk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadOrganizationSDKWithChan(request *DownloadOrganizationSDKRequest) (<-chan *DownloadOrganizationSDKResponse, <-chan error) {
	responseChan := make(chan *DownloadOrganizationSDKResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadOrganizationSDK(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadOrganizationSDKWithCallback invokes the baas.DownloadOrganizationSDK API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadorganizationsdk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadOrganizationSDKWithCallback(request *DownloadOrganizationSDKRequest, callback func(response *DownloadOrganizationSDKResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadOrganizationSDKResponse
		var err error
		defer close(result)
		response, err = client.DownloadOrganizationSDK(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadOrganizationSDKRequest is the request struct for api DownloadOrganizationSDK
type DownloadOrganizationSDKRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
	Username       string `position:"Query" name:"Username"`
}

// DownloadOrganizationSDKResponse is the response struct for api DownloadOrganizationSDK
type DownloadOrganizationSDKResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDownloadOrganizationSDKRequest creates a request to invoke DownloadOrganizationSDK API
func CreateDownloadOrganizationSDKRequest() (request *DownloadOrganizationSDKRequest) {
	request = &DownloadOrganizationSDKRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DownloadOrganizationSDK", "", "")
	return
}

// CreateDownloadOrganizationSDKResponse creates a response to parse from DownloadOrganizationSDK response
func CreateDownloadOrganizationSDKResponse() (response *DownloadOrganizationSDKResponse) {
	response = &DownloadOrganizationSDKResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
