package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBusinessDetails invokes the cloudwf.ListBusinessDetails API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listbusinessdetails.html
func (client *Client) ListBusinessDetails(request *ListBusinessDetailsRequest) (response *ListBusinessDetailsResponse, err error) {
	response = CreateListBusinessDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// ListBusinessDetailsWithChan invokes the cloudwf.ListBusinessDetails API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listbusinessdetails.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBusinessDetailsWithChan(request *ListBusinessDetailsRequest) (<-chan *ListBusinessDetailsResponse, <-chan error) {
	responseChan := make(chan *ListBusinessDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBusinessDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBusinessDetailsWithCallback invokes the cloudwf.ListBusinessDetails API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listbusinessdetails.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBusinessDetailsWithCallback(request *ListBusinessDetailsRequest, callback func(response *ListBusinessDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBusinessDetailsResponse
		var err error
		defer close(result)
		response, err = client.ListBusinessDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBusinessDetailsRequest is the request struct for api ListBusinessDetails
type ListBusinessDetailsRequest struct {
	*requests.RpcRequest
	OrderCol   string           `position:"Query" name:"OrderCol"`
	SearchName string           `position:"Query" name:"SearchName"`
	Length     requests.Integer `position:"Query" name:"Length"`
	PageIndex  requests.Integer `position:"Query" name:"PageIndex"`
	OrderDir   string           `position:"Query" name:"OrderDir"`
}

// ListBusinessDetailsResponse is the response struct for api ListBusinessDetails
type ListBusinessDetailsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListBusinessDetailsRequest creates a request to invoke ListBusinessDetails API
func CreateListBusinessDetailsRequest() (request *ListBusinessDetailsRequest) {
	request = &ListBusinessDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListBusinessDetails", "cloudwf", "openAPI")
	return
}

// CreateListBusinessDetailsResponse creates a response to parse from ListBusinessDetails response
func CreateListBusinessDetailsResponse() (response *ListBusinessDetailsResponse) {
	response = &ListBusinessDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
