package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateZoneRemark invokes the pvtz.UpdateZoneRemark API synchronously
// api document: https://help.aliyun.com/api/pvtz/updatezoneremark.html
func (client *Client) UpdateZoneRemark(request *UpdateZoneRemarkRequest) (response *UpdateZoneRemarkResponse, err error) {
	response = CreateUpdateZoneRemarkResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateZoneRemarkWithChan invokes the pvtz.UpdateZoneRemark API asynchronously
// api document: https://help.aliyun.com/api/pvtz/updatezoneremark.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateZoneRemarkWithChan(request *UpdateZoneRemarkRequest) (<-chan *UpdateZoneRemarkResponse, <-chan error) {
	responseChan := make(chan *UpdateZoneRemarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateZoneRemark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateZoneRemarkWithCallback invokes the pvtz.UpdateZoneRemark API asynchronously
// api document: https://help.aliyun.com/api/pvtz/updatezoneremark.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateZoneRemarkWithCallback(request *UpdateZoneRemarkRequest, callback func(response *UpdateZoneRemarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateZoneRemarkResponse
		var err error
		defer close(result)
		response, err = client.UpdateZoneRemark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateZoneRemarkRequest is the request struct for api UpdateZoneRemark
type UpdateZoneRemarkRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	ZoneId       string `position:"Query" name:"ZoneId"`
	Remark       string `position:"Query" name:"Remark"`
	Lang         string `position:"Query" name:"Lang"`
}

// UpdateZoneRemarkResponse is the response struct for api UpdateZoneRemark
type UpdateZoneRemarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ZoneId    string `json:"ZoneId" xml:"ZoneId"`
}

// CreateUpdateZoneRemarkRequest creates a request to invoke UpdateZoneRemark API
func CreateUpdateZoneRemarkRequest() (request *UpdateZoneRemarkRequest) {
	request = &UpdateZoneRemarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "UpdateZoneRemark", "pvtz", "openAPI")
	return
}

// CreateUpdateZoneRemarkResponse creates a response to parse from UpdateZoneRemark response
func CreateUpdateZoneRemarkResponse() (response *UpdateZoneRemarkResponse) {
	response = &UpdateZoneRemarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
