// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package storagetables

import original "github.com/Azure/azure-sdk-for-go/services/preview/storage/tables/2019-02-02-preview/storagetables"

const (
	DefaultVersion = original.DefaultVersion
)

type GeoReplicationStatusType = original.GeoReplicationStatusType

const (
	Bootstrap   GeoReplicationStatusType = original.Bootstrap
	Live        GeoReplicationStatusType = original.Live
	Unavailable GeoReplicationStatusType = original.Unavailable
)

type OdataMetadataFormat = original.OdataMetadataFormat

const (
	Applicationjsonodatafullmetadata    OdataMetadataFormat = original.Applicationjsonodatafullmetadata
	Applicationjsonodataminimalmetadata OdataMetadataFormat = original.Applicationjsonodataminimalmetadata
	Applicationjsonodatanometadata      OdataMetadataFormat = original.Applicationjsonodatanometadata
)

type ResponseFormat = original.ResponseFormat

const (
	ReturnContent   ResponseFormat = original.ReturnContent
	ReturnNoContent ResponseFormat = original.ReturnNoContent
)

type AccessPolicy = original.AccessPolicy
type BaseClient = original.BaseClient
type CorsRule = original.CorsRule
type GeoReplication = original.GeoReplication
type ListSignedIdentifier = original.ListSignedIdentifier
type Logging = original.Logging
type Metrics = original.Metrics
type RetentionPolicy = original.RetentionPolicy
type ServiceClient = original.ServiceClient
type SetSetObject = original.SetSetObject
type SignedIdentifier = original.SignedIdentifier
type TableClient = original.TableClient
type TableEntityQueryResponse = original.TableEntityQueryResponse
type TableProperties = original.TableProperties
type TableQueryResponse = original.TableQueryResponse
type TableResponse = original.TableResponse
type TableResponseProperties = original.TableResponseProperties
type TableServiceError = original.TableServiceError
type TableServiceProperties = original.TableServiceProperties
type TableServiceStats = original.TableServiceStats

func New(URL string) BaseClient {
	return original.New(URL)
}
func NewServiceClient(URL string) ServiceClient {
	return original.NewServiceClient(URL)
}
func NewTableClient(URL string) TableClient {
	return original.NewTableClient(URL)
}
func NewWithoutDefaults(URL string, version string) BaseClient {
	return original.NewWithoutDefaults(URL, version)
}
func PossibleGeoReplicationStatusTypeValues() []GeoReplicationStatusType {
	return original.PossibleGeoReplicationStatusTypeValues()
}
func PossibleOdataMetadataFormatValues() []OdataMetadataFormat {
	return original.PossibleOdataMetadataFormatValues()
}
func PossibleResponseFormatValues() []ResponseFormat {
	return original.PossibleResponseFormatValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
