// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Snapshot snapshot
// swagger:model Snapshot
type Snapshot struct {

	// Action performed on the instance snapshot
	Action string `json:"action,omitempty"`

	// Creation Date
	// Format: date-time
	CreationDate strfmt.DateTime `json:"creationDate,omitempty"`

	// Description of the PVM instance snapshot
	Description string `json:"description,omitempty"`

	// Last Update Date
	// Format: date-time
	LastUpdateDate strfmt.DateTime `json:"lastUpdateDate,omitempty"`

	// Name of the PVM instance snapshot
	// Required: true
	Name *string `json:"name"`

	// Snapshot completion percentage
	PercentComplete int64 `json:"percentComplete,omitempty"`

	// PCloud PVM Instance ID
	// Required: true
	PvmInstanceID *string `json:"pvmInstanceID"`

	// ID of the PVM instance snapshot
	// Required: true
	SnapshotID *string `json:"snapshotID"`

	// Status of the PVM instancesnapshot
	Status string `json:"status,omitempty"`

	// A map of volume snapshots included in the PVM instance snapshot
	// Required: true
	VolumeSnapshots map[string]string `json:"volumeSnapshots"`
}

// Validate validates this snapshot
func (m *Snapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreationDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePvmInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Snapshot) validateCreationDate(formats strfmt.Registry) error {

	if swag.IsZero(m.CreationDate) { // not required
		return nil
	}

	if err := validate.FormatOf("creationDate", "body", "date-time", m.CreationDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validateLastUpdateDate(formats strfmt.Registry) error {

	if swag.IsZero(m.LastUpdateDate) { // not required
		return nil
	}

	if err := validate.FormatOf("lastUpdateDate", "body", "date-time", m.LastUpdateDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validatePvmInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("pvmInstanceID", "body", m.PvmInstanceID); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validateSnapshotID(formats strfmt.Registry) error {

	if err := validate.Required("snapshotID", "body", m.SnapshotID); err != nil {
		return err
	}

	return nil
}

func (m *Snapshot) validateVolumeSnapshots(formats strfmt.Registry) error {

	return nil
}

// MarshalBinary interface implementation
func (m *Snapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Snapshot) UnmarshalBinary(b []byte) error {
	var res Snapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
