package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDdosStatus invokes the ddospro.DescribeDdosStatus API synchronously
// api document: https://help.aliyun.com/api/ddospro/describeddosstatus.html
func (client *Client) DescribeDdosStatus(request *DescribeDdosStatusRequest) (response *DescribeDdosStatusResponse, err error) {
	response = CreateDescribeDdosStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDdosStatusWithChan invokes the ddospro.DescribeDdosStatus API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeddosstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDdosStatusWithChan(request *DescribeDdosStatusRequest) (<-chan *DescribeDdosStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDdosStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDdosStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDdosStatusWithCallback invokes the ddospro.DescribeDdosStatus API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeddosstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDdosStatusWithCallback(request *DescribeDdosStatusRequest, callback func(response *DescribeDdosStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDdosStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDdosStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDdosStatusRequest is the request struct for api DescribeDdosStatus
type DescribeDdosStatusRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Vips            *[]string        `position:"Query" name:"Vips"  type:"Repeated"`
}

// DescribeDdosStatusResponse is the response struct for api DescribeDdosStatus
type DescribeDdosStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      []Data `json:"Data" xml:"Data"`
}

// CreateDescribeDdosStatusRequest creates a request to invoke DescribeDdosStatus API
func CreateDescribeDdosStatusRequest() (request *DescribeDdosStatusRequest) {
	request = &DescribeDdosStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "DescribeDdosStatus", "", "")
	return
}

// CreateDescribeDdosStatusResponse creates a response to parse from DescribeDdosStatus response
func CreateDescribeDdosStatusResponse() (response *DescribeDdosStatusResponse) {
	response = &DescribeDdosStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
