package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNetworkOptimization invokes the smartag.ModifyNetworkOptimization API synchronously
// api document: https://help.aliyun.com/api/smartag/modifynetworkoptimization.html
func (client *Client) ModifyNetworkOptimization(request *ModifyNetworkOptimizationRequest) (response *ModifyNetworkOptimizationResponse, err error) {
	response = CreateModifyNetworkOptimizationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNetworkOptimizationWithChan invokes the smartag.ModifyNetworkOptimization API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifynetworkoptimization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyNetworkOptimizationWithChan(request *ModifyNetworkOptimizationRequest) (<-chan *ModifyNetworkOptimizationResponse, <-chan error) {
	responseChan := make(chan *ModifyNetworkOptimizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNetworkOptimization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNetworkOptimizationWithCallback invokes the smartag.ModifyNetworkOptimization API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifynetworkoptimization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyNetworkOptimizationWithCallback(request *ModifyNetworkOptimizationRequest, callback func(response *ModifyNetworkOptimizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNetworkOptimizationResponse
		var err error
		defer close(result)
		response, err = client.ModifyNetworkOptimization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNetworkOptimizationRequest is the request struct for api ModifyNetworkOptimization
type ModifyNetworkOptimizationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	NetworkOptId         string           `position:"Query" name:"NetworkOptId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Name                 string           `position:"Query" name:"Name"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyNetworkOptimizationResponse is the response struct for api ModifyNetworkOptimization
type ModifyNetworkOptimizationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNetworkOptimizationRequest creates a request to invoke ModifyNetworkOptimization API
func CreateModifyNetworkOptimizationRequest() (request *ModifyNetworkOptimizationRequest) {
	request = &ModifyNetworkOptimizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifyNetworkOptimization", "smartag", "openAPI")
	return
}

// CreateModifyNetworkOptimizationResponse creates a response to parse from ModifyNetworkOptimization response
func CreateModifyNetworkOptimizationResponse() (response *ModifyNetworkOptimizationResponse) {
	response = &ModifyNetworkOptimizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
