// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The connector configuration information that is required to access the repository.
	//
	// Configuration is a required field
	Configuration *DataSourceConfiguration `type:"structure" required:"true"`

	// A description for the data source.
	Description *string `min:"1" type:"string"`

	// The identifier of the index that should be associated with this data source.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// A unique name for the data source. A data source name can't be changed without
	// deleting and recreating the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a role with permission to access the data
	// source. For more information, see IAM Roles for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// Sets the frequency that Amazon Kendra will check the documents in your repository
	// and update the index. If you don't set a schedule Amazon Kendra will not
	// periodically update the index. You can call the StartDataSourceSyncJob operation
	// to update the index.
	Schedule *string `type:"string"`

	// The type of repository that contains the data source.
	//
	// Type is a required field
	Type DataSourceType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDataSourceInput"}

	if s.Configuration == nil {
		invalidParams.Add(aws.NewErrParamRequired("Configuration"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the data source.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Creates a data source that you use to with an Amazon Kendra index.
//
// You specify a name, connector type and description for your data source.
// You can choose between an S3 connector, a SharePoint Online connector, and
// a database connector.
//
// You also specify configuration information such as document metadata (author,
// source URI, and so on) and user context information.
//
// CreateDataSource is a synchronous operation. The operation returns 200 if
// the data source was successfully created. Otherwise, an exception is raised.
//
//    // Example sending a request using CreateDataSourceRequest.
//    req := client.CreateDataSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/CreateDataSource
func (c *Client) CreateDataSourceRequest(input *CreateDataSourceInput) CreateDataSourceRequest {
	op := &aws.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	req := c.newRequest(op, input, &CreateDataSourceOutput{})
	return CreateDataSourceRequest{Request: req, Input: input, Copy: c.CreateDataSourceRequest}
}

// CreateDataSourceRequest is the request type for the
// CreateDataSource API operation.
type CreateDataSourceRequest struct {
	*aws.Request
	Input *CreateDataSourceInput
	Copy  func(*CreateDataSourceInput) CreateDataSourceRequest
}

// Send marshals and sends the CreateDataSource API request.
func (r CreateDataSourceRequest) Send(ctx context.Context) (*CreateDataSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDataSourceResponse{
		CreateDataSourceOutput: r.Request.Data.(*CreateDataSourceOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDataSourceResponse is the response type for the
// CreateDataSource API operation.
type CreateDataSourceResponse struct {
	*CreateDataSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDataSource request.
func (r *CreateDataSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
